/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.workflows.nodes;

import com.google.common.base.Joiner;
import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RegisterClarinWorkflowFromTemplateJobNode
extends SimpleJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(RegisterClarinWorkflowFromTemplateJobNode.class);
    private String wfName;
    private String wfTemplate;
    private String description;
    private WorkflowProcess process;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ISLookUpClient isLookUpClient;

    public String getWfName() {
        return this.wfName;
    }

    public void setWfName(String wfName) {
        this.wfName = wfName;
    }

    public String getWfTemplate() {
        return this.wfTemplate;
    }

    public void setWfTemplate(String wfTemplate) {
        this.wfTemplate = wfTemplate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected String execute(Env env) throws Exception {
        String dsId = this.process.getDsId();
        String ifaceId = this.process.getDsInterface();
        String dsName = this.process.getDsName();
        StringTemplate profTemplate = new StringTemplate(IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.getWfTemplate()), (Charset)Charset.forName("UTF-8")));
        profTemplate.setAttribute("name", (Object)StringEscapeUtils.escapeXml11((String)this.wfName));
        profTemplate.setAttribute("desc", (Object)StringEscapeUtils.escapeXml11((String)this.description));
        profTemplate.setAttribute("priority", 50);
        profTemplate.setAttribute("dsId", (Object)StringEscapeUtils.escapeXml11((String)dsId));
        profTemplate.setAttribute("interface", (Object)StringEscapeUtils.escapeXml11((String)ifaceId));
        profTemplate.setAttribute("dsName", (Object)StringEscapeUtils.escapeXml11((String)dsName));
        profTemplate.setAttribute("tdsCsv", (Object)this.getListOfTDS(ifaceId));
        String profId = ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(profTemplate.toString());
        env.setAttribute("repoWfId", (Object)profId);
        log.info((Object)("A new repo wf has been registered, id: " + profId));
        return Arc.DEFAULT_ARC;
    }

    private String getListOfTDS(String ifaceId) throws ISLookUpException {
        String lastAPIPart = StringUtils.substringAfterLast((String)ifaceId, (String)"::");
        String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return $x[starts-with(.//TITLE/text() , '" + lastAPIPart + "')]//RESOURCE_IDENTIFIER/@value/string()";
        return Joiner.on((char)',').join((Iterable)this.isLookUpClient.search(query));
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

