package eu.dnetlib.parthenos.workflows.nodes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.web.client.RestTemplate;

/**
 * Created by Alessia Bardi on 01/03/2018.
 *
 * @author Alessia Bardi
 */
public class VirtuosoParthenosByTypeIterator extends VirtuosoParthenosIterator {

	private static final Log log = LogFactory.getLog(VirtuosoParthenosByTypeIterator.class);
	private String typeName;
	private String typeNamespace;

	@Override
	protected URI getURIForSubjectList(final int offset) throws URISyntaxException {
		URIBuilder builder = new URIBuilder(getVirtuosoReaderAPIUrl() + "/apiSubjectsWithType");
		builder.addParameter("api", getDatasourceInterface());
		builder.addParameter("typeNamespace", typeNamespace);
		builder.addParameter("typeName", typeName);
		builder.addParameter("limit", Integer.toString(LIMIT));
		builder.addParameter("offset", Integer.toString(offset));
		return builder.build();
	}

	@Override
	protected URI getURIForRDFRequest(final String subjectURL) throws URISyntaxException {
		URIBuilder builder = new URIBuilder(getVirtuosoReaderAPIUrl() + "/subject").addParameter("subjectURL", subjectURL).addParameter("typeName", typeName).addParameter("timeout", ANY_TIME_QUERY_MS);
		return  builder.build();
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(final String typeName) {
		this.typeName = typeName;
	}

	public String getTypeNamespace() {
		return typeNamespace;
	}

	public void setTypeNamespace(final String typeNamespace) {
		this.typeNamespace = typeNamespace;
	}

	public VirtuosoParthenosByTypeIterator typeName(final String typeName) {
		this.typeName = typeName;
		return this;
	}

	public VirtuosoParthenosByTypeIterator typeNamespace(final String typeNamespace) {
		this.typeNamespace = typeNamespace;
		return this;
	}

	@Override
	public VirtuosoParthenosByTypeIterator restTemplate(final RestTemplate restTemplate) {
		setRestTemplate(restTemplate);
		return this;
	}
	@Override
	public VirtuosoParthenosByTypeIterator datasourceInterface(final String datasourceInterface) {
		setDatasourceInterface(datasourceInterface);
		return this;
	}
	@Override
	public VirtuosoParthenosByTypeIterator virtuosoReaderAPIUrl(final String virtuosoReaderAPIUrl) {
		setVirtuosoReaderAPIUrl(virtuosoReaderAPIUrl);
		return this;
	}
	@Override
	public VirtuosoParthenosByTypeIterator datasourceName(final String datasourceName) {
		setDatasourceName(datasourceName);
		return this;
	}
	@Override
	public VirtuosoParthenosByTypeIterator errors(final Map<String, Integer> errors) {
		setErrors(errors);
		return this;
	}
}
