/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.parthenos.workflows.nodes;

import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.parthenos.workflows.nodes.ClarinFileVisitor;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ClarinAPIGeneratorJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(ClarinAPIGeneratorJobNode.class);
    private String folderPath;
    private String inputBaseUrlPrefix;
    private String metadataIdentifierPath;
    private String clarinDatasourceProfileID;
    private String clarinDatasourceOriginalId;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ISLookUpClient isLookupClient;

    protected String execute(Env env) throws Exception {
        Path folder = Paths.get(this.getFolderPath(), new String[0]);
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            throw new IllegalArgumentException(this.getFolderPath() + " must be a directory");
        }
        DatasourceManagerService dsMan = (DatasourceManagerService)this.getServiceLocator().getService(DatasourceManagerService.class);
        List apiIds = this.getIsLookupClient().search("//RESOURCE_PROFILE[./HEADER/RESOURCE_IDENTIFIER/@value='" + this.getClarinDatasourceProfileID() + "']//INTERFACE/@id/string()");
        ClarinFileVisitor visitor = new ClarinFileVisitor(this.getClarinDatasourceProfileID(), this.getClarinDatasourceOriginalId(), this.getInputBaseUrlPrefix(), this.getMetadataIdentifierPath(), apiIds, this.getServiceLocator(), this.getIsLookupClient());
        Files.walkFileTree(folder, visitor);
        env.setAttribute("mainlog:visitedFiles", (Object)visitor.getCountVisitedFiles());
        env.setAttribute("mainlog:createdTDS", (Object)visitor.getCountCreatedTDS());
        env.setAttribute("mainlog:updatedTDS", (Object)visitor.getCountUpdatedTDS());
        env.setAttribute("mainlog:visitedFolders", (Object)visitor.getCountVisitedFolders());
        env.setAttribute("mainlog:createdInterfaces", (Object)visitor.getCountCreatedInterfaces());
        return Arc.DEFAULT_ARC;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getInputBaseUrlPrefix() {
        return this.inputBaseUrlPrefix;
    }

    public void setInputBaseUrlPrefix(String inputBaseUrlPrefix) {
        this.inputBaseUrlPrefix = inputBaseUrlPrefix;
    }

    public String getMetadataIdentifierPath() {
        return this.metadataIdentifierPath;
    }

    public void setMetadataIdentifierPath(String metadataIdentifierPath) {
        this.metadataIdentifierPath = metadataIdentifierPath;
    }

    public String getClarinDatasourceProfileID() {
        return this.clarinDatasourceProfileID;
    }

    public void setClarinDatasourceProfileID(String clarinDatasourceProfileID) {
        this.clarinDatasourceProfileID = clarinDatasourceProfileID;
    }

    public String getClarinDatasourceOriginalId() {
        return this.clarinDatasourceOriginalId;
    }

    public void setClarinDatasourceOriginalId(String clarinDatasourceOriginalId) {
        this.clarinDatasourceOriginalId = clarinDatasourceOriginalId;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public ISLookUpClient getIsLookupClient() {
        return this.isLookupClient;
    }

    public void setIsLookupClient(ISLookUpClient isLookupClient) {
        this.isLookupClient = isLookupClient;
    }
}

