package eu.dnetlib.parthenos.workflows.nodes;

import java.nio.charset.Charset;

import com.google.common.base.Joiner;
import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Copied from eu.dnetlib.msro.workflows.nodes.repohi.RegisterWorkflowFromTemplateJobNode
 *
 * Clarin specific implementation for setting the transformation rules automatically.
 *
 * @author alessia
 */
public class RegisterClarinWorkflowFromTemplateJobNode extends SimpleJobNode implements ProcessAware {

	private static final Log log = LogFactory.getLog(RegisterClarinWorkflowFromTemplateJobNode.class);
	private String wfName;
	private String wfTemplate;
	private String description;
	private WorkflowProcess process;
	@Autowired
	private UniqueServiceLocator serviceLocator;
	@Autowired
	private ISLookUpClient isLookUpClient;

	public String getWfName() {
		return this.wfName;
	}

	public void setWfName(final String wfName) {
		this.wfName = wfName;
	}

	public String getWfTemplate() {
		return this.wfTemplate;
	}

	public void setWfTemplate(final String wfTemplate) {
		this.wfTemplate = wfTemplate;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	@Override
	protected String execute(final Env env) throws Exception {
		final String dsId = this.process.getDsId();
		final String ifaceId = this.process.getDsInterface();
		final String dsName = this.process.getDsName();

		final StringTemplate profTemplate = new StringTemplate(IOUtils.toString(getClass().getResourceAsStream(getWfTemplate()), Charset.forName("UTF-8")));
		profTemplate.setAttribute("name", StringEscapeUtils.escapeXml11(this.wfName));
		profTemplate.setAttribute("desc", StringEscapeUtils.escapeXml11(this.description));
		profTemplate.setAttribute("priority", WorkflowsConstants.DEFAULT_WF_PRIORITY);
		profTemplate.setAttribute("dsId", StringEscapeUtils.escapeXml11(dsId));
		profTemplate.setAttribute("interface", StringEscapeUtils.escapeXml11(ifaceId));
		profTemplate.setAttribute("dsName", StringEscapeUtils.escapeXml11(dsName));
		profTemplate.setAttribute("tdsCsv", getListOfTDS(ifaceId));

		final String profId = this.serviceLocator.getService(ISRegistryService.class).registerProfile(profTemplate.toString());

		env.setAttribute("repoWfId", profId);

		log.info("A new repo wf has been registered, id: " + profId);

		return Arc.DEFAULT_ARC;
	}

	private String getListOfTDS(final String ifaceId) throws ISLookUpException {
		String lastAPIPart = StringUtils.substringAfterLast(ifaceId, "::");
		String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return $x[starts-with(.//TITLE/text() , '"+lastAPIPart+"')]//RESOURCE_IDENTIFIER/@value/string()";
		return Joiner.on(',').join(isLookUpClient.search(query));
	}

	public WorkflowProcess getProcess() {
		return this.process;
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}



}
