package eu.dnetlib.parthenos.workflows.nodes;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Alessia Bardi on 12/01/2018.
 *
 * @author Alessia Bardi
 */
public class ClarinAPIGeneratorJobNode extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(ClarinAPIGeneratorJobNode.class);

	/** Path to a local folder containing the subfolders with Clarin mapping files **/
	private String folderPath;
	/** Path to a local folder containing the subfolders with Clarin input files **/
	private String inputBaseUrlPrefix;

	private String metadataIdentifierPath;

	private String clarinDatasourceProfileID;
	private String clarinDatasourceOriginalId;

	@Autowired
	private UniqueServiceLocator serviceLocator;
	@Autowired
	private ISLookUpClient isLookupClient;


	@Override
	protected String execute(final Env env) throws Exception {
		Path folder = Paths.get(getFolderPath());
		if (!Files.isDirectory(folder)){
			throw new IllegalArgumentException(getFolderPath()+" must be a directory");
		}
		final DatasourceManagerService dsMan = getServiceLocator().getService(DatasourceManagerService.class);

		List<String> apiIds = getIsLookupClient().search("//RESOURCE_PROFILE[./HEADER/RESOURCE_IDENTIFIER/@value='"+getClarinDatasourceProfileID()+"']//INTERFACE/@id/string()");

		ClarinFileVisitor visitor = new ClarinFileVisitor(getClarinDatasourceProfileID(), getClarinDatasourceOriginalId(),
				getInputBaseUrlPrefix(), getMetadataIdentifierPath(), apiIds, getServiceLocator(), getIsLookupClient());
		Files.walkFileTree(folder, visitor);

		env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX +"visitedFiles", visitor.getCountVisitedFiles());
		env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX +"createdTDS", visitor.getCountCreatedTDS());
		env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX +"updatedTDS", visitor.getCountUpdatedTDS());
		env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX +"visitedFolders", visitor.getCountVisitedFolders());
		env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX +"createdInterfaces", visitor.getCountCreatedInterfaces());
		return Arc.DEFAULT_ARC;

	}

	public String getFolderPath() {
		return folderPath;
	}

	public void setFolderPath(final String folderPath) {
		this.folderPath = folderPath;
	}

	public String getInputBaseUrlPrefix() {
		return inputBaseUrlPrefix;
	}

	public void setInputBaseUrlPrefix(final String inputBaseUrlPrefix) {
		this.inputBaseUrlPrefix = inputBaseUrlPrefix;
	}

	public String getMetadataIdentifierPath() {
		return metadataIdentifierPath;
	}

	public void setMetadataIdentifierPath(final String metadataIdentifierPath) {
		this.metadataIdentifierPath = metadataIdentifierPath;
	}

	public String getClarinDatasourceProfileID() {
		return clarinDatasourceProfileID;
	}

	public void setClarinDatasourceProfileID(final String clarinDatasourceProfileID) {
		this.clarinDatasourceProfileID = clarinDatasourceProfileID;
	}

	public String getClarinDatasourceOriginalId() {
		return clarinDatasourceOriginalId;
	}

	public void setClarinDatasourceOriginalId(final String clarinDatasourceOriginalId) {
		this.clarinDatasourceOriginalId = clarinDatasourceOriginalId;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public ISLookUpClient getIsLookupClient() {
		return isLookupClient;
	}

	public void setIsLookupClient(final ISLookUpClient isLookupClient) {
		this.isLookupClient = isLookupClient;
	}
}
