package eu.dnetlib.functionality.modular.ui.patcheditor.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;

public class EfgAvCreationConverter {

	public Map calculateJsonForPatchEdit(Element element) {
		final Map<String, Object> map = new HashMap<String, Object>();

		// Titles
		final List<Map<String, String>> titles = new ArrayList<Map<String, String>>();
		for (final Object o : element.selectNodes("//*[local-name() = 'avcreation']/*[local-name() = 'title']")) {
			final Map<String, String> title = new HashMap<String, String>();
			title.put("text", ((Node) o).valueOf("normalize-space(./*[local-name() = 'text'])"));
			title.put("type", ((Node) o).valueOf("normalize-space(./*[local-name() = 'relation'])"));
			title.put("language", ((Node) o).valueOf("./@lang"));
			titles.add(title);
		}
		map.put("titles", titles);

		// Description
		final List<Map<String, String>> descriptions = new ArrayList<Map<String, String>>();
		for (final Object o : element.selectNodes("//*[local-name() = 'avcreation']/*[local-name() = 'description']")) {
			final Map<String, String> desc = new HashMap<String, String>();
			desc.put("text", ((Node) o).valueOf("normalize-space(text())"));
			desc.put("type", ((Node) o).valueOf("./@type"));
			desc.put("language", ((Node) o).valueOf("./@lang"));
			descriptions.add(desc);
		}
		map.put("descriptions", descriptions);

		// Category
		// Country
		map.put("countryOfReference", element.valueOf("//*[local-name() = 'countryOfReference']").trim());

		// Year
		map.put("productionYear", element.valueOf("//*[local-name() = 'productionYear']").trim());

		// Gauge
		map.put("gauge", element.valueOf("//*[local-name() = 'gauge']").trim());

		// Duration
		map.put("duration", element.valueOf("//*[local-name() = 'duration']").trim());

		// Provenance
		map.put("provenance", element.valueOf("//*[local-name() = 'provenance']").trim());

		// Languages
		final List<Map<String, String>> languages = new ArrayList<Map<String, String>>();
		for (final Object o : element.selectNodes("//*[local-name() = 'language']")) {
			final Map<String, String> lang = new HashMap<String, String>();
			lang.put("text", ((Node) o).valueOf("normalize-space(text())").trim());
			lang.put("usage", ((Node) o).valueOf("./@usage").trim());
			languages.add(lang);
		}
		map.put("languages", languages);

		// Colour
		final Map<String, String> colour = new HashMap<String, String>();
		colour.put("text", element.valueOf("//*[local-name() = 'colour']"));
		colour.put("hasColor", element.valueOf("//*[local-name() = 'colour']/@hasColor"));
		map.put("colour", colour);

		// Sound
		final Map<String, String> sound = new HashMap<String, String>();
		sound.put("text", element.valueOf("//*[local-name() = 'sound']"));
		sound.put("hasSound", element.valueOf("//*[local-name() = 'sound']/@hasSound"));
		map.put("sound", sound);

		// Manifestation
		// Rights
		final Map<String, String> rights = new HashMap<String, String>();
		rights.put("status", element.valueOf("normalize-space(.//*[local-name() = 'rightsStatus'])"));
		rights.put("holder", element.valueOf("normalize-space(.//*[local-name() = 'rightsHolder'])"));
		rights.put("holderUrl", element.valueOf("normalize-space(.//*[local-name() = 'rightsHolder']/@URL)"));
		map.put("rights", rights);

		// Digital Object
		final Map<String, String> digitalObject = new HashMap<String, String>();
		digitalObject.put("thumbnail", element.valueOf("normalize-space(.//*[local-name() = 'thumbnail'])"));
		digitalObject.put("isShownAt", element.valueOf("normalize-space(.//*[local-name() = 'isShownAt'])"));
		digitalObject.put("isShownBy", element.valueOf("normalize-space(.//*[local-name() = 'isShownBy'])"));
		digitalObject.put("aggregator", element.valueOf("normalize-space(.//*[local-name() = 'aggregator'])"));
		map.put("digitalObject", digitalObject);

		// subjects LCSH
		final List<Map<String, String>> keywords = new ArrayList<Map<String, String>>();
		for (final Object o : element.selectNodes("//*[local-name() = 'keywords']")) {
			final Map<String, String> sub = new HashMap<String, String>();
			sub.put("term", ((Node) o).valueOf("normalize-space(./*[local-name() = 'term'])"));
			sub.put("type", ((Node) o).valueOf("./@type"));
			sub.put("id", ((Node) o).valueOf("./*[local-name() = 'term']/@id"));
			sub.put("language", ((Node) o).valueOf("./@lang"));
			keywords.add(sub);
		}
		map.put("keywords", keywords);

		// Collection
		final List<Map<String, String>> collections = new ArrayList<Map<String, String>>();
		for (final Object o : element.selectNodes("//*[local-name() = 'collection']")) {
			final Map<String, String> coll = new HashMap<String, String>();
			coll.put("term", ((Node) o).valueOf("normalize-space(./*[local-name() = 'text'])"));
			coll.put("type", ((Node) o).valueOf("./@type"));
			collections.add(coll);
		}
		map.put("collections", collections);

		return map;
	}

}
