/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.patcheditor.client;

import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.clients.index.client.response.LookupResponse;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexPatchEditorClient {
    private static final Log log = LogFactory.getLog(IndexPatchEditorClient.class);
    @Autowired
    private ResolvingIndexClientFactory indexClientFactory;
    private Map<String, IndexClient> indexClientMap;

    public String getDocument(IndexConfiguration idx, String field, String id) throws IndexServiceException, ResultSetException {
        String query = field + " exact \"" + id.trim() + "\"";
        IndexClient indexClient = this.getIndexClient(idx);
        LookupResponse lookupResponse = indexClient.lookup(query, null, 0, 1);
        int total = (int)lookupResponse.getTotal();
        if (total != 1) {
            log.error((Object)("Invalid number of results (" + total + ") for query: " + query));
            throw new IllegalArgumentException("Invalid number of results (" + total + ") for query: " + query);
        }
        String record = (String)lookupResponse.getRecords().get(0);
        return record;
    }

    private IndexClient getIndexClient(IndexConfiguration configuration) throws IndexClientException {
        if (this.indexClientMap == null) {
            this.indexClientMap = new HashMap<String, IndexClient>();
        }
        if (this.indexClientMap.containsKey(configuration.getBackendId())) {
            return this.indexClientMap.get(configuration.getBackendId());
        }
        IndexClient index = this.indexClientFactory.getClient(configuration.getFormat(), configuration.getLayout(), configuration.getInterpretation(), configuration.getBackendId());
        this.indexClientMap.put(configuration.getBackendId(), index);
        return index;
    }
}

