package eu.dnetlib.functionality.modular.ui.patcheditor.client;

import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.clients.index.client.response.LookupResponse;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexPatchEditorClient {

	private static final Log log = LogFactory.getLog(IndexPatchEditorClient.class);
	@Autowired
	private ResolvingIndexClientFactory indexClientFactory;
	private Map<String, IndexClient> indexClientMap;

	public String getDocument(final IndexConfiguration idx, final String field, final String id) throws IndexServiceException,
			ResultSetException {

		final String query = field + " exact \"" + id.trim() + "\"";
		final IndexClient indexClient = getIndexClient(idx);
		final LookupResponse lookupResponse = indexClient.lookup(query, null, 0, 1);

		final int total = (int) lookupResponse.getTotal();
		if (total != 1) {
			log.error("Invalid number of results (" + total + ") for query: " + query);
			throw new IllegalArgumentException("Invalid number of results (" + total + ") for query: " + query);
		}

		final String record = lookupResponse.getRecords().get(0);

		return record;
	}

	private IndexClient getIndexClient(final IndexConfiguration configuration) throws IndexClientException {
		if (indexClientMap == null) {
			indexClientMap = new HashMap<>();
		}
		if (indexClientMap.containsKey(configuration.getBackendId())) { return indexClientMap.get(configuration.getBackendId()); }
		final IndexClient index = indexClientFactory.getClient(configuration.getFormat(), configuration.getLayout(), configuration.getInterpretation(),
				configuration.getBackendId());
		indexClientMap.put(configuration.getBackendId(), index);

		return index;
	}
}
