/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.patcheditor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.lightui.LightUIUtils;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupLightUIClient;
import eu.dnetlib.functionality.modular.ui.patcheditor.client.IndexPatchEditorClient;
import eu.dnetlib.functionality.modular.ui.patcheditor.converters.EfgAvCreationConverter;
import eu.dnetlib.functionality.modular.ui.patcheditor.converters.EfgNonAvCreationConverter;
import eu.dnetlib.functionality.modular.ui.patcheditor.exceptions.PatchEditorException;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.LSCH;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.Patch;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.PatchManager;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.PatchedRecord;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.UIAction;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Relation;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Synonym;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Term;
import eu.dnetlib.functionality.modular.ui.vocabularies.persistence.VocabularyException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PatchEditorController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(PatchEditorController.class);
    @Resource
    private PatchManager patchManager;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private IndexPatchEditorClient indexPatchEditorClient;
    @Resource
    private ISLookupLightUIClient isLookupClient;

    @RequestMapping(path={"/ui/patcheditor/titleTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getTitleTypes() throws Exception {
        List<Term> terms = this.getVocabularies("AVTitleType");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/languages"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getLanguages() throws Exception {
        List<Term> terms = this.getVocabularies("Names of Languages");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/countries"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getCountries() throws Exception {
        List<Term> terms = this.getVocabularies("Iso3166-1CountryCS");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/keywordTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getKeywordTypes() throws Exception {
        List<Term> terms = this.getVocabularies("KeywordType");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/sounds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getSounds() throws Exception {
        List<Term> terms = this.getVocabularies("Sound");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/colours"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getColours() throws Exception {
        List<Term> terms = this.getVocabularies("Colour");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/languageUsages"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getLanguageUsages() throws Exception {
        List<Term> terms = this.getVocabularies("LanguageUsage");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/descriptionTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getDescriptionTypes() throws Exception {
        List<Term> terms = this.getVocabularies("DescriptionType");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/rightsStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getRightsStatus() throws Exception {
        List<Term> terms = this.getVocabularies("RightsStatus");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/gauge"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Term> getGauge() throws Exception {
        List<Term> terms = this.getVocabularies("Gauge");
        return terms;
    }

    @RequestMapping(path={"/ui/patcheditor/lsch"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LSCH> getLSCH() throws Exception {
        List<LSCH> lschs = this.loadLSCH();
        return lschs;
    }

    @RequestMapping(path={"/ui/patcheditor/record"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getRecord(@RequestParam(value="recordId", required=true) String recordId) throws Exception {
        PatchedRecord patchedRecord = this.createPatchedRecord(recordId);
        patchedRecord.getData().put("repositoryId", patchedRecord.getRepositoryId());
        patchedRecord.getData().put("entityType", patchedRecord.getType());
        return patchedRecord.getData();
    }

    @RequestMapping(path={"/ui/patcheditor/existPatchNotIndexed"}, method={RequestMethod.GET})
    @ResponseBody
    public String existPatchNotIndexed(@RequestParam(value="repositoryId", required=true) String repositoryId, @RequestParam(value="recordId", required=true) String recordId) throws Exception {
        boolean existPatchNotIndexed = this.patchManager.existPatchNotIndexed(repositoryId, recordId);
        if (existPatchNotIndexed) {
            return "true";
        }
        return "";
    }

    @RequestMapping(path={"/ui/applyPatches.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String applyPatches(ModelMap map, HttpSession httpSession, @RequestParam(value="id", required=true) String id, @RequestParam(value="patches", required=true) String patches) {
        this.generateActions(map, httpSession, id, patches);
        return "ok";
    }

    private List<Term> getVocabularies(String codeValue) throws PatchEditorException {
        List<Term> terms = null;
        try {
            String query = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') where ($x//VOCABULARY_NAME/@code='" + codeValue + "') return $x";
            List countries = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
            terms = this.getTerms((String)countries.get(0));
        }
        catch (ISLookUpException e) {
            throw new PatchEditorException(e);
        }
        return terms;
    }

    private List<Term> getTerms(String vocabulary) throws PatchEditorException {
        try {
            Document doc = new SAXReader().read((Reader)new StringReader(vocabulary));
            HashMap terms = Maps.newHashMap();
            for (Object t : doc.selectNodes("//TERM")) {
                Term term;
                Element termNode = (Element)t;
                String code = termNode.valueOf("@code");
                if (!terms.containsKey(code)) {
                    term = new Term();
                    term.setEnglishName(termNode.valueOf("@english_name"));
                    term.setNativeName(termNode.valueOf("@native_name"));
                    term.setEncoding(termNode.valueOf("@encoding"));
                    term.setCode(code);
                    term.setSynonyms(new ArrayList());
                    term.setRelations(new ArrayList());
                    terms.put(code, term);
                }
                term = (Term)terms.get(code);
                for (Object s : termNode.selectNodes(".//SYNONYM")) {
                    Element synNode = (Element)s;
                    Synonym syn = new Synonym();
                    syn.setTerm(synNode.valueOf("@term"));
                    syn.setEncoding(synNode.valueOf("@encoding"));
                    term.getSynonyms().add(syn);
                }
                for (Object r : termNode.selectNodes(".//RELATION")) {
                    Element relNode = (Element)r;
                    Relation rel = new Relation();
                    rel.setCode(relNode.valueOf("@code"));
                    rel.setType(relNode.valueOf("@type"));
                    term.getRelations().add(rel);
                }
                Collections.sort(term.getSynonyms());
                Collections.sort(term.getRelations());
            }
            ArrayList list = Lists.newArrayList(terms.values());
            Collections.sort(list);
            return list;
        }
        catch (DocumentException e) {
            throw new PatchEditorException((Throwable)new VocabularyException((Exception)((Object)e)));
        }
    }

    private List<LSCH> loadLSCH() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/eu/dnetlib/web/LSCH.csv")));
            Gson g = new Gson();
            String s = br.readLine();
            ArrayList<LSCH> lschs = new ArrayList<LSCH>();
            while (s != null) {
                String[] lsch = s.split(";");
                lschs.add(new LSCH(lsch[1], lsch[0], lsch[2]));
                s = br.readLine();
            }
            return lschs;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Node getConfigurationNode(String lightuiId, String xpath, String id) throws Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(this.isLookupClient.getLightUiProfile(lightuiId)));
        return doc.selectSingleNode(xpath);
    }

    private String getDocument(String lightuiId, String field, String id) throws Exception {
        Node searchNode = this.getConfigurationNode(lightuiId, "//DOCUMENT", id);
        return this.indexPatchEditorClient.getDocument(LightUIUtils.calculateIndexConfiguration((Node)searchNode), field, id);
    }

    public PatchedRecord createPatchedRecord(String recordId) throws PatchEditorException {
        try {
            String lightuiId = "eagle";
            String field = "objidentifier";
            String recordPlain = this.getDocument("eagle", "objidentifier", recordId);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(recordPlain));
            String repoId = doc.valueOf("//*[local-name()='repositoryId']");
            String type = doc.valueOf("local-name(//*[local-name()='efgEntity']/*)");
            Map patchedRecordData = null;
            if (type.equals("avcreation")) {
                EfgAvCreationConverter conv = new EfgAvCreationConverter();
                patchedRecordData = conv.calculateJsonForPatchEdit(doc.getRootElement());
            } else if (type.equals("nonavcreation")) {
                EfgNonAvCreationConverter conv = new EfgNonAvCreationConverter();
                patchedRecordData = conv.calculateJsonForPatchEdit(doc.getRootElement());
            } else {
                throw new PatchEditorException("patches can be only applied for avcreation and nonavcreation types");
            }
            return new PatchedRecord(recordId, repoId, patchedRecordData, type, new ArrayList<Patch>());
        }
        catch (Exception e) {
            throw new PatchEditorException(e);
        }
    }

    private void generateActions(ModelMap map, HttpSession httpSession, String recordId, String jsonPatches) {
        try {
            UIAction[] arrayAction;
            PatchedRecord record = this.createPatchedRecord(recordId);
            String type = record.getType();
            UIAction.EntityTypes entityType = UIAction.EntityTypes.valueOf(type);
            ArrayList<Patch> patches = new ArrayList<Patch>();
            for (UIAction element : arrayAction = (UIAction[])new Gson().fromJson(jsonPatches, UIAction[].class)) {
                element.setEntityType(entityType);
                patches.addAll(element.asPatches());
            }
            record.setPatches(patches);
            this.patchManager.commit(record);
            map.addAttribute("response", (Object)"OK");
        }
        catch (Exception e) {
            log.warn((Object)e);
            map.addAttribute("response", (Object)"FAIL");
        }
    }
}

