/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.patcheditor.record;

import eu.dnetlib.functionality.modular.ui.patcheditor.record.Patch;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.RecordBase;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class PatchedRecord
extends RecordBase
implements Serializable {
    private static final long serialVersionUID = 5568968614948509411L;
    private List<Patch> patches;
    private String recordType;
    private static final Log log = LogFactory.getLog(PatchedRecord.class);

    public PatchedRecord() {
    }

    public PatchedRecord(String id, String repositoryId, Map data, String type, List<Patch> patches) {
        super(id, repositoryId, type, data);
        this.patches = patches;
        this.recordType = type;
    }

    @Override
    public String asXML() {
        SAXReader reader = new SAXReader();
        Element root = DocumentHelper.createElement((String)"record");
        Element header = root.addElement("header");
        header.addElement(new QName("objIdentifier", driNS)).setText(this.getId());
        header.addElement(new QName("repositoryId", driNS)).setText(this.getRepositoryId());
        header.addElement(new QName("dateOfCollection", driNS)).setText(DateUtils.now_ISO8601());
        Element patchRoot = root.addElement("metadata").addElement("patches");
        block5: for (Patch p : this.patches) {
            Element patchNode = patchRoot.addElement("patch");
            patchNode.addAttribute("xpath", p.getContextXpath());
            patchNode.addAttribute("operation", p.getOperation().toString());
            patchNode.addAttribute("creationDate", p.getCreationDate());
            switch (p.getOperation()) {
                case ADDSUBTREE: {
                    try {
                        Document doc = reader.read((Reader)new StringReader(p.getValue()));
                        patchNode.add(doc.getRootElement().createCopy());
                    }
                    catch (DocumentException e) {
                        log.error((Object)("Error parsing the patch value: " + p.getValue()));
                    }
                    continue block5;
                }
            }
            patchNode.addAttribute("value", p.getValue());
        }
        return root.asXML();
    }

    public List<Patch> getPatches() {
        return this.patches;
    }

    public void setPatches(List<Patch> patches) {
        this.patches = patches;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }
}

