var patchEditorControllers = angular.module('patchEditorUIControllers', []);

function Patch()
{
    this.operation="";
    this.fieldType="";
    this.value="";
    
}

patchEditorControllers.controller('patchEditorCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
    function ($scope, $http, $sce, $location, $routeParams) {
		 $scope.navbarItems=[{"name":"Title","link":"Title"}, 
             {"name":"Keyword","link":"Keyword"},
             {"name":"LCSH", "link":"Lcsh"},
             {"name":"Descritpion","link":"Descritpion"},
             {"name":"Rights","link":"Rights"},
             {"name":"Digital Object","link":"DigitalObject"},
             {"name":"Country","link":"country"},
             {"name":"Year","link":"year"},
             {"name":"Language","link":"language"},
             {"name":"Colour","link":"colour"},
             {"name":"Sound","link":"sound"},
             {"name":"Gauge","link":"gauge"},
             {"name":"Duration","link":"duration"},
             {"name":"Provenance","link":"provenance"}
             ];
		$scope.recordId = $routeParams.recordId;
		$scope.patchedRecord = '';
		$scope.booleanValues = [
	        {
	            id: 'true', name: 'true'},
	        {
	            id: 'false', name: 'false'}];
		
		$scope.loadRecord = function () {
			$http.get('patcheditor/record?recordId=' + $scope.recordId)
				.success(
					function (data) {
						$scope.patchedRecord = data;
						$scope.repositoryId = data.repositoryId;
						$scope.entityType = data.entityType;
						$scope.rightsStatus = $scope.patchedRecord.rights.status;
						$scope.holder = $scope.patchedRecord.rights.holder;
						$scope.holderUrl = $scope.patchedRecord.rights.holderUrl;
						if ($scope.entityType=='avcreation') {
							$scope.originalRecords={
							        'rights':{"status":$scope.patchedRecord.rights.status,"holderUrl":$scope.patchedRecord.rights.holderUrl, "holder":$scope.patchedRecord.rights.holder},
							        "countryOfReference":$scope.patchedRecord.countryOfReference,
							        "digitalObject":{"isShownAt":$scope.patchedRecord.digitalObject.isShownAt,"aggregator":$scope.patchedRecord.digitalObject.aggregator,"thumbnail":$scope.patchedRecord.digitalObject.thumbnail,"isShownBy":$scope.patchedRecord.digitalObject.isShownBy},
							        "productionYear":$scope.patchedRecord.productionYear,
							        "colour":{"text":$scope.patchedRecord.colour.text,"hasColor":$scope.patchedRecord.colour.hasColor},
							        "provenance":$scope.patchedRecord.provenance,        
							        "duration":$scope.patchedRecord.duration,
							        "sound":{"text":$scope.patchedRecord.sound.text,"hasSound":$scope.patchedRecord.sound.hasSound},
							        "gauge":$scope.patchedRecord.gauge       
							    };
						}
						else if ($scope.entityType=='nonavcreation') {
							$scope.originalRecords={
							        'rights':{"status":$scope.patchedRecord.rights.status,"holderUrl":$scope.patchedRecord.rights.holderUrl, "holder":$scope.patchedRecord.rights.holder},
							        "digitalObject":{"isShownAt":$scope.patchedRecord.digitalObject.isShownAt,"aggregator":$scope.patchedRecord.digitalObject.aggregator,"thumbnail":$scope.patchedRecord.digitalObject.thumbnail,"isShownBy":$scope.patchedRecord.digitalObject.isShownBy},
							        "colour":{"text":$scope.patchedRecord.colour.text,"hasColor":$scope.patchedRecord.colour.hasColor},
							        "provenance":$scope.patchedRecord.provenance,        
							        "gauge":$scope.patchedRecord.gauge       
							    };
						}
						$scope.searchPatchNotIndexed();
					}
				)
				.error(
					function () {
						show_notification('error', 'Cannot load record ');
					}
				);
		}
		$scope.loadRecord();
		
		$scope.searchPatchNotIndexed = function() {
	        $http.get('patcheditor/existPatchNotIndexed?repositoryId=' + $scope.repositoryId + '&recordId=' + $scope.recordId).success(function (data) {
	        	if (data == 'true') {
	        		$scope.existPatchNotIndexed = true;
	        	}
	        	else {
	        		$scope.existPatchNotIndexed = undefined;
	        	}
	        }).error(function () {
	            show_notification('error', 'Error searching not indexed patches ');
	        });

		}
		
		$scope.loadLanguages = function() {
	        $http.get('patcheditor/languages').success(function (data) {
	            $scope.languages = data;
	        }).error(function () {
	            show_notification('error', 'Error getting languages ');
	        });

		}		
		$scope.loadLanguages();
		
		$scope.loadCountry = function() {
	        $http.get('patcheditor/countries').success(function (data) {
	            $scope.countries = data;
	        }).error(function () {
	            show_notification('error', 'Error getting countries ');
	        });

		}	
		$scope.loadCountry();
		
		$scope.loadTitleTypes = function() {
	        $http.get('patcheditor/titleTypes').success(function (data) {
	            $scope.titleTypes = data;
	        }).error(function () {
	            show_notification('error', 'Error getting titleTypes ');
	        });

		}		
		$scope.loadTitleTypes();
		
		$scope.loadKeywordTypes = function() {
	        $http.get('patcheditor/keywordTypes').success(function (data) {
	            $scope.keywordTypes = data;
	        }).error(function () {
	            show_notification('error', 'Error getting keywordTypes ');
	        });

		}		
		$scope.loadKeywordTypes();
		
		$scope.loadLSCH = function() {
	        $http.get('patcheditor/lsch').success(function (data) {
	            $scope.lsch = data;
	        }).error(function () {
	            show_notification('error', 'Error getting LSCH ');
	        });

		}		
		$scope.loadLSCH();
		
		$scope.loadDescriptionTypes = function() {
	        $http.get('patcheditor/descriptionTypes').success(function (data) {
	            $scope.descriptionTypes = data;
	        }).error(function () {
	            show_notification('error', 'Error getting descriptionTypes ');
	        });

		}		
		$scope.loadDescriptionTypes();
		
		
		$scope.loadRightsStatus = function() {
	        $http.get('patcheditor/rightsStatus').success(function (data) {
	            $scope.rightsStatusValues = data;
	        }).error(function () {
	            show_notification('error', 'Error getting RightsStatus ');
	        });

		}		
		$scope.loadRightsStatus();
		
		$scope.loadLanguageUsages = function() {
	        $http.get('patcheditor/languageUsages').success(function (data) {
	            $scope.languageUsages = data;
	        }).error(function () {
	            show_notification('error', 'Error getting LanguageUsages ');
	        });

		}		
		$scope.loadLanguageUsages();
		
		
		$scope.loadColours = function() {
	        $http.get('patcheditor/colours').success(function (data) {
	            $scope.colours = data;
	        }).error(function () {
	            show_notification('error', 'Error getting Colours ');
	        });

		}		
		$scope.loadColours();		

		$scope.loadSounds = function() {
	        $http.get('patcheditor/sounds').success(function (data) {
	            $scope.sounds = data;
	        }).error(function () {
	            show_notification('error', 'Error getting Sounds ');
	        });

		}		
		$scope.loadSounds();
		
		$scope.loadGauge = function() {
	        $http.get('patcheditor/gauge').success(function (data) {
	            $scope.gauge = data;
	        }).error(function () {
	            show_notification('error', 'Error getting Gauge ');
	        });

		}		
		$scope.loadGauge();
		
		$scope.addTitle=function()
	    {
	        var NewRecord=[{"text":"","language":"","type":"", "edited":"true"}];
	        NewRecord=NewRecord.concat($scope.patchedRecord.titles);        
	        $scope.patchedRecord.titles=NewRecord;
	    }
		
		$scope.removeTitle=function(id)
	    {
		    var titles=$scope.patchedRecord.titles;
	        titles.splice(id,1);       
	    }
		
		$scope.addKeyword=function()
	    {
	        var NewRecord=[{"id":"","term":"","type":"", "edited":"true"}];
	        NewRecord=NewRecord.concat($scope.patchedRecord.keywords);        
	        $scope.patchedRecord.keywords=NewRecord;        
	    }
	    
	    $scope.removeKeyword=function(id)
	    {
	        
	        var keywords=$scope.patchedRecord.keywords;
	        keywords.splice(id,1);       
	    }
	    
	    $scope.addLCSH=function()
	    {
	        var NewRecord=[{"id":" ","term":"","type":"", "edited":"true"}];
	        NewRecord=NewRecord.concat($scope.patchedRecord.keywords);        
	        $scope.patchedRecord.keywords=NewRecord;      
	    }
	    
	    $scope.addDescription=function()
	    {
	        var NewRecord=[{"text":"","language":"","type":"", "edited":"true"}];
	        NewRecord=NewRecord.concat($scope.patchedRecord.descriptions);        
	        $scope.patchedRecord.descriptions=NewRecord;      
	    }
	    
	    $scope.removeDescription=function(id)
	    {
	        
	        var Descriptions=$scope.patchedRecord.descriptions;
	        Descriptions.splice(id,1);       
	    }
	    
	    $scope.addLanguage=function()
	    {
	        var NewRecord=[{"text":"","usage":"", "edited":"true"}];
	        NewRecord=NewRecord.concat($scope.patchedRecord.languages);        
	        $scope.patchedRecord.languages=NewRecord;      
	    }
	    
	    $scope.removeLanguage=function(id)
	    {
	        
	        var languages=$scope.patchedRecord.languages;
	        languages.splice(id,1);       
	    }
		
		$scope.commit=function()
	    {
			var patches = $scope.searchPatch ();
	        if (patches.length >0)
	    	{
	        	$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('applyPatches.do', $.param({
					'id': $scope.recordId,
					'patches': JSON.stringify(patches)
				}))
					.success(function (data) {
						show_notification('success', 'Patch applied ');
						$scope.searchPatchNotIndexed();
					}).error(function (error) {
						show_notification('error', 'Error applying patches: ' + error.message);
				});
	        }
	        else {
	        	show_notification('info', 'No patches to commit');
	        }
	    }
		
		$scope.getLCSHObject=function(id)
	    {
	        for(var i=0,j=$scope.lsch.length; i<j; i++){
	          if ($scope.lsch[i].id==id)
	            return $scope.lsch[i];
	        };
	    }
		
		$scope.searchPatch=function()
	    {
	        var patches=[];   
	        
	        for(var i=0,j=$scope.patchedRecord.titles.length; i<j; i++)
	        {
		          var currentTitle =$scope.patchedRecord.titles[i];
		          if (currentTitle.edited!=null)
		          {
		              if ((currentTitle.text!=null) || (currentTitle.text.length))
		              {
		                  var tmp= new Patch();
		                  tmp.fieldType="title"
		                  tmp.operation="ADDSUBTREE"
		                  tmp.value=currentTitle.text+"::-::"+currentTitle.type+"::-::"+currentTitle.language;
		                  if (currentTitle.text.length)
		                    patches.push(tmp);                  
		              }
		          }         
		        }
	        
	        for(var i=0,j=$scope.patchedRecord.keywords.length; i<j; i++)
	        {
	          var currentkeyword =$scope.patchedRecord.keywords[i];
	          if (currentkeyword.edited!=null)
	          {
	          	   var tmp= new Patch();
	              	tmp.fieldType="keyword"
	              	tmp.operation="ADDSUBTREE"
	              	if(currentkeyword.id.length)
	              	{ 	
	                  var currentLSCHterm= $scope.getLCSHObject (currentkeyword.term);
	                  tmp.value=currentLSCHterm.id+"::-::"+currentLSCHterm.term+"::-::"+currentLSCHterm.URL+"::-::LCSH::-::EN";
	                  patches.push(tmp); 
	                 }                  
	                 else
	              		{
	                  	tmp.value="undef::-::"+currentkeyword.term+"::-::undef"+"::-::"+currentkeyword.type +"::-::"+currentkeyword.language;  
	                  	if (currentkeyword.term.length)
	                    patches.push(tmp); 
	              		}    
	              	
	          }         
	        }
	        
	        for(var i=0,j=$scope.patchedRecord.descriptions.length; i<j; i++){
	          var currentDescriptions =$scope.patchedRecord.descriptions[i];
	          if (currentDescriptions.edited!=null)
	          {
	              if ((currentDescriptions.text!=null) || (currentDescriptions.text.length))
	              {
	                  var tmp= new Patch();
	                  tmp.fieldType="description"
	                  tmp.operation="ADDSUBTREE"
	                  tmp.value=currentDescriptions.text+"::-::"+currentDescriptions.type+"::-::"+currentDescriptions.language;
	                  if (currentDescriptions.text.length)
	                    patches.push(tmp);                  
	              }
	          }         
	        }
	        
	        if ($scope.originalRecords.digitalObject.isShownAt != $scope.patchedRecord.digitalObject.isShownAt)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="isShownAt";
	            if ($scope.patchedRecord.digitalObject.isShownAt==null)
	                tmp.operation="DELETENODE"
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.digitalObject.isShownAt;
	            patches.push(tmp);             
	        }
	        
	        if ($scope.originalRecords.digitalObject.isShownBy != $scope.patchedRecord.digitalObject.isShownBy)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="isShownBy";
	            if ($scope.patchedRecord.digitalObject.isShownBy==null)
	                tmp.operation="DELETENODE"
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.digitalObject.isShownBy;
	            patches.push(tmp);             
	        }
	        
	        if ($scope.originalRecords.digitalObject.aggregator != $scope.patchedRecord.digitalObject.aggregator)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="aggregator";
	            if (($scope.patchedRecord.digitalObject.aggregator==null)|| (!$scope.patchedRecord.digitalObject.aggregator.length) )
	                tmp.operation="DELETENODE"
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.digitalObject.aggregator;
	            patches.push(tmp);             
	        }
	        
	        if ($scope.originalRecords.digitalObject.thumbnail != $scope.patchedRecord.digitalObject.thumbnail)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="thumbnail";
	            if (($scope.patchedRecord.digitalObject.thumbnail==null) || (!$scope.patchedRecord.digitalObject.thumbnail.length))
	                tmp.operation="DELETENODE"
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.digitalObject.thumbnail;
	            patches.push(tmp);             
	        }
	        
	        if ($scope.originalRecords.rights.status != $scope.patchedRecord.rights.status)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="rightsStatus";
	            if (($scope.patchedRecord.rights.status==null) || (!$scope.patchedRecord.rights.status.length))
	                tmp.operation="DELETENODE"
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.rights.status;
	            patches.push(tmp);             
	        }
	        
	        if (($scope.originalRecords.rights.holderUrl != $scope.patchedRecord.rights.holderUrl) | ($scope.originalRecords.rights.holder != $scope.patchedRecord.rights.holder) )
	        {
	            var tmp= new Patch();
	            tmp.fieldType="rightsholderUrl";
	            if ( (($scope.patchedRecord.rights.holderUrl==null) || (!$scope.patchedRecord.rights.holderUrl.length)) && (($scope.patchedRecord.rights.holder==null) || (!$scope.patchedRecord.rights.holder.length)))
	            {	            	
	                tmp.operation="DELETENODE"
	            }
	            else
	                tmp.operation="EDIT";
	                
	            var mholder=$scope.patchedRecord.rights.holder;
	            if ((mholder== null) | (!mholder.length))
	            	mholder= "undef"
	            var mholderUrl=$scope.patchedRecord.rights.holderUrl;
	            if ((mholderUrl== null) | (!mholderUrl.length))
	            	mholderUrl= "undef"
	                
	                                        
	            tmp.value= mholder+"::-::"+mholderUrl;
	            patches.push(tmp);             
	        }
	        
	        if ($scope.entityType=='avcreation') {
		        if ($scope.originalRecords.countryOfReference != $scope.patchedRecord.countryOfReference)
		        {
		            var tmp= new Patch();
		            tmp.fieldType="countryOfReference";
		            if ($scope.patchedRecord.countryOfReference==null)
		                tmp.operation="DELETENODE"
		            else
		                tmp.operation="EDIT";                           
		            tmp.value= $scope.patchedRecord.countryOfReference;
		            patches.push(tmp);             
		        }
	        }
	
	        if ($scope.entityType=='avcreation') {
		        if ($scope.originalRecords.productionYear != $scope.patchedRecord.productionYear)
		        {
		            var tmp= new Patch();
		            tmp.fieldType="productionYear";
		            if ($scope.patchedRecord.productionYear==null)
		                tmp.operation="DELETENODE"
		            else
		                tmp.operation="EDIT";                           
		            tmp.value= $scope.patchedRecord.productionYear;
		            patches.push(tmp);             
		        }
	        }
	 
	        for(var i=0,j=$scope.patchedRecord.languages.length; i<j; i++){
	          var currentLanguages =$scope.patchedRecord.languages[i];
	          if (currentLanguages.edited!=null)
	          {
	              if ((currentLanguages.text!=null) || (currentLanguages.text.length))
	              {
	                  var tmp= new Patch();
	                  tmp.fieldType="language"
	                  tmp.operation="ADDSUBTREE"
	                  tmp.value=currentLanguages.text+"::-::"+currentLanguages.usage;
	                  if (currentLanguages.text.length)
	                    patches.push(tmp);                  
	              }
	          }         
	        }
	      
	        if (($scope.originalRecords.colour.text != $scope.patchedRecord.colour.text)|| ($scope.originalRecords.colour.hasColor != $scope.patchedRecord.colour.hasColor)  )
	        {
	            var tmp= new Patch();
	            tmp.fieldType="colour";
	            if ($scope.patchedRecord.colour.text==null)
	                tmp.operation="DELETENODE";
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.colour.text+"::-::"+ $scope.patchedRecord.colour.hasColor;
	            patches.push(tmp);             
	        }  
	        
	        if ($scope.entityType=='avcreation') {
		        if (($scope.originalRecords.sound.text != $scope.patchedRecord.sound.text)|| ($scope.originalRecords.sound.hasSound != $scope.patchedRecord.sound.hasSound)  )
		        {
		            var tmp= new Patch();
		            if ($scope.patchedRecord.sound.text==null)
		                tmp.operation="DELETENODE";
		            else
		                tmp.operation="EDIT";
		            tmp.fieldType="sound";                                       
		            tmp.value= $scope.patchedRecord.sound.text+"::-::"+ $scope.patchedRecord.sound.hasSound;
		            patches.push(tmp);             
		        }
	        }
	        if ($scope.originalRecords.gauge != $scope.patchedRecord.gauge)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="gauge";
	            if($scope.patchedRecord.gauge==null)
	                tmp.operation="DELETENODE"
	            else 
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.gauge;
	            patches.push(tmp);             
	        }
	        
	        if ($scope.entityType=='avcreation') {
		        if ($scope.originalRecords.duration != $scope.patchedRecord.duration)
		        {
		            var tmp= new Patch();
		            tmp.fieldType="duration";
		            if ($scope.patchedRecord.duration==null)
		                tmp.operation="DELETENODE"
		            else
		                tmp.operation="EDIT";                           
		            tmp.value= $scope.patchedRecord.duration;
		            patches.push(tmp);             
		        }
	        }
	        if ($scope.originalRecords.provenance != $scope.patchedRecord.provenance)
	        {
	            var tmp= new Patch();
	            tmp.fieldType="provenance";
	            if ($scope.patchedRecord.provenance==null)
	                tmp.operation="DELETENODE"
	            else
	                tmp.operation="EDIT";                           
	            tmp.value= $scope.patchedRecord.provenance;
	            patches.push(tmp);             
	        }
	        return patches;             
	    }
		
		
	}
]);
