package eu.dnetlib.functionality.modular.ui.patcheditor.record;

import eu.dnetlib.functionality.modular.ui.patcheditor.exceptions.PatchEditorException;
import java.io.Serializable;
import org.dom4j.Namespace;

public abstract class RecordBase implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 3600383637831186888L;

	protected static final Namespace driNS = new Namespace("dri", "http://www.driver-repository.eu/namespace/dri");

	private String id;
	private String repositoryId;
	private String type;

	public RecordBase() {}

	public RecordBase(String id, String repositoryId, String type) {
		super();
		this.id = id;
		this.repositoryId = repositoryId;
		this.type = type;
	}

	abstract public String asXML() throws PatchEditorException;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRepositoryId() {
		return repositoryId;
	}

	public void setRepositoryId(String repositoryId) {
		this.repositoryId = repositoryId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getShortId() {
		return id.substring(id.indexOf("::") + 2);
	}
}
