package eu.dnetlib.functionality.modular.ui.patcheditor.converters;

import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.CollectionData;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Color;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Description;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.DigitalObject;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Keyword;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Language;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Record;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Right;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Title;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class EfgNonAvCreationConverter {

	public Record calculateRecordForPatchEdit(Element element) {
		final Record record = new Record();

		// Titles
		final List<Title> titles = new ArrayList<Title>();
		for (final Object o : element.selectNodes("//*[local-name() = 'nonavcreation']/*[local-name() = 'title']")) {
			final Title title = new Title();
			title.setText(((Node) o).valueOf("normalize-space(./*[local-name() = 'text'])"));
			title.setType(((Node) o).valueOf("normalize-space(./*[local-name() = 'relation'])"));
			title.setLanguage(((Node) o).valueOf("./@lang"));
			titles.add(title);
		}
		record.getTitles().addAll(titles);

		// Description
		final List<Description> descriptions = new ArrayList<Description>();
		for (final Object o : element.selectNodes("//*[local-name() = 'nonavcreation']/*[local-name() = 'description']")) {
			final Description desc = new Description();
			desc.setText(((Node) o).valueOf("normalize-space(text())"));
			desc.setType(((Node) o).valueOf("./@type"));
			desc.setLanguage(((Node) o).valueOf("./@lang"));
			descriptions.add(desc);
		}
		record.getDescriptions().addAll(descriptions);

		// Provenance
		record.setProvenance(element.valueOf("//*[local-name() = 'provenance']").trim());

		// Languages
		final List<Language> languages = new ArrayList<Language>();
		for (final Object o : element.selectNodes("//*[local-name() = 'language']")) {
			final Language lang = new Language();
			lang.setText(((Node) o).valueOf("normalize-space(text())").trim());
			lang.setUsage(((Node) o).valueOf("./@usage").trim());
			languages.add(lang);
		}
		record.getLanguages().addAll(languages);

		// Gauge
		record.setGauge(element.valueOf("//*[local-name() = 'gauge']").trim());

		// Colour
		final Color colour = new Color();
		colour.setText(element.valueOf("//*[local-name() = 'colour']"));
		colour.setHasColor(element.valueOf("//*[local-name() = 'colour']/@hasColor"));
		record.setColour(colour);

		// Manifestation
		// Rights
		final Right rights = new Right();
		rights.setStatus(element.valueOf("normalize-space(.//*[local-name() = 'rightsStatus'])"));
		rights.setHolder(element.valueOf("normalize-space(.//*[local-name() = 'rightsHolder'])"));
		rights.setHolderUrl(element.valueOf("normalize-space(.//*[local-name() = 'rightsHolder']/@URL)"));
		record.setRights(rights);

		// Digital Object
		final DigitalObject digitalObject = new DigitalObject();
		digitalObject.setThumbnail(element.valueOf("normalize-space(.//*[local-name() = 'thumbnail'])"));
		digitalObject.setIsShownAt(element.valueOf("normalize-space(.//*[local-name() = 'isShownAt'])"));
		digitalObject.setIsShownBy(element.valueOf("normalize-space(.//*[local-name() = 'isShownBy'])"));
		digitalObject.setAggregator(element.valueOf("normalize-space(.//*[local-name() = 'aggregator'])"));
		record.setDigitalObject(digitalObject);

		// subjects LCSH
		final List<Keyword> keywords = new ArrayList<Keyword>();
		for (final Object o : element.selectNodes("//*[local-name() = 'keywords']")) {
			final Keyword key = new Keyword();
			key.setTerm(((Node) o).valueOf("normalize-space(./*[local-name() = 'term'])"));
			key.setType(((Node) o).valueOf("./@type"));
			key.setId(((Node) o).valueOf("./*[local-name() = 'term']/@id"));
			key.setLanguage(((Node) o).valueOf("./@lang"));
			keywords.add(key);
		}
		record.getKeywords().addAll(keywords);

		// Collection
		final List<CollectionData> collections = new ArrayList<CollectionData>();
		for (final Object o : element.selectNodes("//*[local-name() = 'collection']")) {
			final CollectionData coll = new CollectionData();
			coll.setTerm(((Node) o).valueOf("normalize-space(./*[local-name() = 'text'])"));
			coll.setType(((Node) o).valueOf("./@type"));
			collections.add(coll);
		}
		record.getCollections().addAll(collections);

		return record;
	}
}
