package eu.dnetlib.functionality.modular.ui.patcheditor.record;

import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Patch;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Record;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.RecordBase;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class PatchedRecord extends RecordBase implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 5568968614948509411L;

	private List<Patch> patches;

	private static final Log log = LogFactory.getLog(PatchedRecord.class);

	private Record record;

	public PatchedRecord() {}

	public PatchedRecord(String id, String repositoryId, Record record, String type, List<Patch> patches) {
		super(id, repositoryId, type);
		this.patches = patches;
		this.record = record;
	}

	@Override
	public String asXML() {
		final SAXReader reader = new SAXReader();

		final Element root = DocumentHelper.createElement("record");
		final Element header = root.addElement("header");
		header.addElement(new QName("objIdentifier", driNS)).setText(getId());
		header.addElement(new QName("repositoryId", driNS)).setText(getRepositoryId());
		header.addElement(new QName("dateOfCollection", driNS)).setText(DateUtils.now_ISO8601());
		final Element patchRoot = root.addElement("metadata").addElement("patches");

		for (final Patch p : patches) {
			final Element patchNode = patchRoot.addElement("patch");
			patchNode.addAttribute("xpath", p.getContextXpath());
			patchNode.addAttribute("operation", p.getOperation().toString());
			patchNode.addAttribute("creationDate", p.getCreationDate());

			switch (p.getOperation()) {
			case ADDSUBTREE:
				try {
					final Document doc = reader.read(new StringReader(p.getValue()));
					patchNode.add(doc.getRootElement().createCopy());
				} catch (final DocumentException e) {
					log.error("Error parsing the patch value: " + p.getValue());
				}
				break;
			default:
				patchNode.addAttribute("value", p.getValue());
				break;
			}
		}
		return root.asXML();
	}

	public List<Patch> getPatches() {
		return patches;
	}

	public void setPatches(List<Patch> patches) {
		this.patches = patches;
	}

	public Record getRecord() {
		return record;
	}

	public void setRecord(Record record) {
		this.record = record;
	}

}
