package eu.dnetlib.functionality.modular.ui.patcheditor.record.model;

import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.Serializable;

public class Patch implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -6630951482851352988L;

	private String contextXpath;
	private Operation operation;
	private String value;
	private String creationDate;

	public Patch() {}

	public Patch(String contextXpath, Operation operation, String value) {
		super();
		this.contextXpath = contextXpath;
		this.operation = operation;
		this.value = value;
		this.setCreationDate(DateUtils.now_ISO8601());
	}

	public Patch(String contextXpath, Operation operation, String value, String creationDate) {
		super();
		this.contextXpath = contextXpath;
		this.operation = operation;
		this.value = value;
		this.creationDate = creationDate;
	}

	public String getContextXpath() {
		return contextXpath;
	}

	public void setContextXpath(String contextXpath) {
		this.contextXpath = contextXpath;
	}

	public Operation getOperation() {
		return operation;
	}

	public void setOperation(Operation operation) {
		this.operation = operation;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(String creationDate) {
		this.creationDate = creationDate;
	}
}
