/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.patcheditor.client;

import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.clients.index.client.response.LookupResponse;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import eu.dnetlib.functionality.modular.ui.patcheditor.exceptions.PatchEditorException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexPatchEditorClient {
    private static final Log log = LogFactory.getLog(IndexPatchEditorClient.class);
    @Autowired
    private ResolvingIndexClientFactory indexClientFactory;
    private Map<String, IndexClient> indexClientMap;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    private IndexClient getIndexClient(IndexConfiguration configuration) throws IndexClientException {
        if (this.indexClientMap == null) {
            this.indexClientMap = new HashMap<String, IndexClient>();
        }
        if (this.indexClientMap.containsKey(configuration.getBackendId())) {
            return this.indexClientMap.get(configuration.getBackendId());
        }
        IndexClient index = this.indexClientFactory.getClient(configuration.getFormat(), configuration.getLayout(), configuration.getInterpretation(), configuration.getBackendId());
        this.indexClientMap.put(configuration.getBackendId(), index);
        return index;
    }

    private String getRepositoryId(String prefix) throws ISLookUpException {
        String getRepositoryIdQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') where ($x//value/text()='anf') return $x//RESOURCE_IDENTIFIER/@value/string()";
        ISLookUpService lookUpClient = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List repositoryIds = lookUpClient.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') where ($x//value/text()='anf') return $x//RESOURCE_IDENTIFIER/@value/string()", prefix));
        if (repositoryIds == null || repositoryIds.size() != 1) {
            throw new RuntimeException("Unexpected number of result executing query " + String.format("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') where ($x//value/text()='anf') return $x//RESOURCE_IDENTIFIER/@value/string()", repositoryIds.get(0)) + " expected: 1");
        }
        return (String)repositoryIds.get(0);
    }

    private String getIndexId(String repositoryId) throws ISLookUpException {
        String getIndexIdQuery = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return $x//PARAM[./@name='indexId']/text()";
        ISLookUpService lookUpClient = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List indexIds = lookUpClient.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return $x//PARAM[./@name='indexId']/text()", repositoryId));
        if (indexIds == null || indexIds.size() != 1) {
            throw new RuntimeException("Unexpected number of result executing query " + String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return $x//PARAM[./@name='indexId']/text()", indexIds.get(0)) + " expected: 1");
        }
        return (String)indexIds.get(0);
    }

    private IndexConfiguration calculateIndexConfiguration(Node node) throws DocumentException, IOException {
        String id = node.valueOf("./BACKEND/@ID");
        String format = node.valueOf("./METADATA_FORMAT/text()");
        String layout = node.valueOf("./METADATA_FORMAT_LAYOUT/text()");
        String interpretation = node.valueOf("./METADATA_FORMAT_INTERPRETATION/text()");
        String backendId = node.valueOf("./BACKEND/text()");
        return new IndexConfiguration(id, format, layout, interpretation, backendId);
    }

    private Node getConfigurationNode(String indexId) throws ISLookUpException, DocumentException {
        String getIndexConfigurationQuery = "for $x in collection('/db/DRIVER/IndexDSResources/IndexDSResourceType')  where ($x//RESOURCE_IDENTIFIER/@value/string()='%s') return $x";
        ISLookUpService lookUpClient = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List indexConfigurations = lookUpClient.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/IndexDSResources/IndexDSResourceType')  where ($x//RESOURCE_IDENTIFIER/@value/string()='%s') return $x", indexId));
        if (indexConfigurations == null || indexConfigurations.size() != 1) {
            throw new RuntimeException("Unexpected number of result executing query " + String.format("for $x in collection('/db/DRIVER/IndexDSResources/IndexDSResourceType')  where ($x//RESOURCE_IDENTIFIER/@value/string()='%s') return $x", indexConfigurations.get(0)) + " expected: 1");
        }
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader((String)indexConfigurations.get(0)));
        return doc.selectSingleNode("//CONFIGURATION");
    }

    public String getDocument(String recordId) throws PatchEditorException {
        String record;
        try {
            String field = "objidentifier";
            String repositoryId = this.getRepositoryId(recordId.split("::")[0]);
            String indexId = this.getIndexId(repositoryId);
            Node configurationNode = this.getConfigurationNode(indexId);
            IndexConfiguration idx = this.calculateIndexConfiguration(configurationNode);
            String query = "objidentifier exact \"" + recordId.trim() + "\"";
            IndexClient indexClient = this.getIndexClient(idx);
            LookupResponse lookupResponse = indexClient.lookup(query, null, 0, 1);
            int total = (int)lookupResponse.getTotal();
            if (total != 1) {
                log.error((Object)("Invalid number of results (" + total + ") for query: " + query));
                throw new IllegalArgumentException("Invalid number of results (" + total + ") for query: " + query);
            }
            record = (String)lookupResponse.getRecords().get(0);
        }
        catch (IndexClientException | ISLookUpException | IOException | DocumentException e) {
            throw new PatchEditorException(e);
        }
        return record;
    }
}

