/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.patcheditor.record;

import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Operation;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.model.Patch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class UIAction
implements Serializable {
    private static final long serialVersionUID = -5689869014308142684L;
    private static final Log log = LogFactory.getLog(UIAction.class);
    private static final Namespace EFG_NS = new Namespace("efg", "http://www.europeanfilmgateway.eu/efg");
    private Operation operation;
    private FieldTypes fieldType;
    private String value;
    private EntityTypes entityType;

    public UIAction() {
    }

    public UIAction(Operation operation, FieldTypes fieldType, String value) {
        this.operation = operation;
        this.fieldType = fieldType;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public FieldTypes getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldTypes fieldType) {
        this.fieldType = fieldType;
    }

    public EntityTypes getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypes entityType) {
        this.entityType = entityType;
    }

    public List<Patch> asPatches() {
        ArrayList<Patch> out = new ArrayList<Patch>();
        switch (this.fieldType) {
            case title: {
                this.processTitle(out);
                break;
            }
            case description: {
                this.processDescription(out);
                break;
            }
            case keyword: {
                this.processKeyword(out);
                break;
            }
            case isShownAt: 
            case isShownBy: 
            case aggregator: {
                this.processItemField(out);
                break;
            }
            case colour: 
            case sound: 
            case gauge: {
                this.processFormatField(out);
                break;
            }
            case thumbnail: 
            case rightsStatus: 
            case duration: 
            case provenance: 
            case specificType: {
                this.processAvManifestationField(out);
                break;
            }
            case rightsholderUrl: {
                this.processManifestationAttribute("rightsHolder", "URL", out);
                break;
            }
            case countryOfReference: 
            case productionYear: {
                this.processField(out);
                break;
            }
            case language: {
                this.processLanguage(out);
                break;
            }
        }
        return out;
    }

    private void processLanguage(List<Patch> out) {
        String[] arr = this.value.split("::-::");
        Element lang = DocumentHelper.createElement((QName)new QName("language", EFG_NS));
        lang.setText(arr[0]);
        lang.addAttribute("usage", arr[1]);
        switch (this.entityType) {
            case avcreation: {
                out.add(new Patch("//*[local-name()='avManifestation']", Operation.ADDSUBTREE, lang.asXML()));
                break;
            }
            case nonavcreation: {
                out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.ADDSUBTREE, lang.asXML()));
                break;
            }
        }
    }

    private void processTitle(List<Patch> out) {
        String[] arr = this.value.split("::-::");
        Element title = DocumentHelper.createElement((QName)new QName("title", EFG_NS));
        title.addElement(new QName("text", EFG_NS)).setText(arr[0]);
        title.addElement(new QName("relation", EFG_NS)).setText(arr[1]);
        title.addAttribute("lang", arr[2]);
        switch (this.entityType) {
            case avcreation: {
                out.add(new Patch("//*[local-name()='avcreation']", Operation.ADDSUBTREE, title.asXML()));
                out.add(new Patch("//*[local-name()='avManifestation']", Operation.ADDSUBTREE, title.asXML()));
                break;
            }
            case nonavcreation: {
                out.add(new Patch("//*[local-name()='nonavcreation']", Operation.ADDSUBTREE, title.asXML()));
                out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.ADDSUBTREE, title.asXML()));
                break;
            }
        }
    }

    private void processKeyword(List<Patch> out) {
        String[] arr = this.value.split("::-::");
        Element subject = DocumentHelper.createElement((QName)new QName("keywords", EFG_NS));
        Element term = subject.addElement(new QName("term", EFG_NS));
        if (!arr[2].equals("undef")) {
            subject.addAttribute("scheme", arr[2]);
        }
        if (!arr[3].equals("undef")) {
            subject.addAttribute("type", arr[3]);
        }
        if (!arr[4].equals("undef")) {
            subject.addAttribute("lang", arr[4]);
        }
        if (!arr[0].equals("undef")) {
            term.addAttribute("id", arr[0]);
        }
        term.setText(arr[1].trim());
        switch (this.entityType) {
            case avcreation: {
                out.add(new Patch("//*[local-name()='avcreation']", Operation.ADDSUBTREE, subject.asXML()));
                break;
            }
            case nonavcreation: {
                out.add(new Patch("//*[local-name()='nonavcreation']", Operation.ADDSUBTREE, subject.asXML()));
                break;
            }
        }
    }

    private void processField(List<Patch> out) {
        switch (this.operation) {
            case EDIT: {
                out.add(new Patch("//*[local-name()='avcreation']", Operation.VERIFYNODE, this.fieldType.toString()));
                out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.EDIT, this.value));
                break;
            }
            case DELETENODE: {
                out.add(new Patch("//*[local-name()='format']", Operation.DELETENODE, this.fieldType.toString()));
                break;
            }
        }
    }

    private void processDescription(List<Patch> out) {
        String[] arr = this.value.split("::-::");
        Element descr = DocumentHelper.createElement((QName)new QName("description", EFG_NS));
        descr.addAttribute("type", arr[1]);
        descr.addAttribute("lang", arr[2]);
        descr.setText(arr[0]);
        switch (this.entityType) {
            case avcreation: {
                out.add(new Patch("//*[local-name()='avcreation']", Operation.ADDSUBTREE, descr.asXML()));
                break;
            }
            case nonavcreation: {
                out.add(new Patch("//*[local-name()='nonavcreation']", Operation.ADDSUBTREE, descr.asXML()));
                break;
            }
        }
    }

    private void processItemField(List<Patch> out) {
        switch (this.operation) {
            case EDIT: {
                switch (this.entityType) {
                    case avcreation: {
                        out.add(new Patch("//*[local-name()='avManifestation']", Operation.VERIFYNODE, "item"));
                        break;
                    }
                    case nonavcreation: {
                        out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.VERIFYNODE, "item"));
                        break;
                    }
                }
                out.add(new Patch("//*[local-name()='item']", Operation.VERIFYNODE, this.fieldType.toString()));
                out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.EDIT, this.value));
                break;
            }
            case DELETENODE: {
                out.add(new Patch("//*[local-name()='item']", Operation.DELETENODE, this.fieldType.toString()));
                break;
            }
        }
    }

    private void processFormatField(List<Patch> out) {
        switch (this.operation) {
            case EDIT: {
                switch (this.entityType) {
                    case avcreation: {
                        out.add(new Patch("//*[local-name()='avManifestation']", Operation.VERIFYNODE, "format"));
                        break;
                    }
                    case nonavcreation: {
                        out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.VERIFYNODE, "format"));
                        break;
                    }
                }
                out.add(new Patch("//*[local-name()='format']", Operation.VERIFYNODE, this.fieldType.toString()));
                if (this.fieldType == FieldTypes.colour) {
                    String[] arr = this.value.split("::-::");
                    out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.EDIT, arr[0]));
                    out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.VERIFYATTRIBUTE, "hasColor"));
                    out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']/@hasColor", Operation.EDIT, arr[1]));
                    break;
                }
                if (this.fieldType == FieldTypes.sound) {
                    String[] arr = this.value.split("::-::");
                    out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.EDIT, arr[0]));
                    out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.VERIFYATTRIBUTE, "hasSound"));
                    out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']/@hasSound", Operation.EDIT, arr[1]));
                    break;
                }
                out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.EDIT, this.value));
                break;
            }
            case DELETENODE: {
                out.add(new Patch("//*[local-name()='format']", Operation.DELETENODE, this.fieldType.toString()));
                break;
            }
        }
    }

    private void processAvManifestationField(List<Patch> out) {
        block0 : switch (this.operation) {
            case EDIT: {
                switch (this.entityType) {
                    case avcreation: {
                        out.add(new Patch("//*[local-name()='avManifestation']", Operation.VERIFYNODE, this.fieldType.toString()));
                        break;
                    }
                    case nonavcreation: {
                        out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.VERIFYNODE, this.fieldType.toString()));
                        break;
                    }
                }
                out.add(new Patch("//*[local-name()='" + this.fieldType.toString() + "']", Operation.EDIT, this.value));
                break;
            }
            case DELETENODE: {
                switch (this.entityType) {
                    case avcreation: {
                        out.add(new Patch("//*[local-name()='avManifestation']", Operation.DELETENODE, this.fieldType.toString()));
                        break block0;
                    }
                    case nonavcreation: {
                        out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.DELETENODE, this.fieldType.toString()));
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void processManifestationAttribute(String nodeName, String attributeName, List<Patch> out) {
        block0 : switch (this.operation) {
            case EDIT: {
                switch (this.entityType) {
                    case avcreation: {
                        out.add(new Patch("//*[local-name()='avManifestation']", Operation.VERIFYNODE, nodeName));
                        break;
                    }
                    case nonavcreation: {
                        out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.VERIFYNODE, nodeName));
                        break;
                    }
                }
                out.add(new Patch("//*[local-name()='" + nodeName + "']", Operation.VERIFYATTRIBUTE, attributeName));
                if (this.fieldType == FieldTypes.rightsholderUrl) {
                    String[] arr = this.value.split("::-::");
                    if (arr[0] != null && arr[0].length() > 0 && !"undef".equals(arr[0])) {
                        out.add(new Patch("//*[local-name()='" + nodeName + "']", Operation.EDIT, arr[0]));
                    }
                    if (arr[1] == null || arr[1].length() <= 0 || "undef".equals(arr[1])) break;
                    out.add(new Patch("//*[local-name()='" + nodeName + "']/@" + attributeName, Operation.EDIT, arr[1]));
                    break;
                }
                out.add(new Patch("//*[local-name()='" + nodeName + "']/@" + attributeName, Operation.EDIT, this.value));
                break;
            }
            case DELETENODE: {
                switch (this.entityType) {
                    case avcreation: {
                        out.add(new Patch("//*[local-name()='avManifestation']", Operation.DELETENODE, this.fieldType.toString()));
                        break block0;
                    }
                    case nonavcreation: {
                        out.add(new Patch("//*[local-name()='nonAVManifestation']", Operation.DELETENODE, this.fieldType.toString()));
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public static enum EntityTypes {
        avcreation,
        nonavcreation;

    }

    public static enum FieldTypes {
        isShownAt,
        isShownBy,
        aggregator,
        thumbnail,
        title,
        rightsStatus,
        rightsholderUrl,
        keyword,
        description,
        duration,
        provenance,
        language,
        colour,
        sound,
        gauge,
        countryOfReference,
        productionYear,
        specificType;

    }
}

