/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.patcheditor.record;

import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreManagerInfo;
import eu.dnetlib.data.mdstore.modular.mongodb.MDStoreTransactionManagerImpl;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.patcheditor.exceptions.PatchEditorException;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.PatchManager;
import eu.dnetlib.functionality.modular.ui.patcheditor.record.PatchedRecord;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class PatchManagerImpl
implements PatchManager {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ISLookupClient isLookupClient;
    @Autowired
    private MDStoreTransactionManagerImpl mdstoreTransactionManager;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    private final SAXReader reader = new SAXReader();
    private static final Log log = LogFactory.getLog(PatchManager.class);

    @Override
    public void commit(PatchedRecord record) throws PatchEditorException {
        try {
            String patchMdStoreId = this.getPatchMDStoreId(record.getRepositoryId());
            MongoCollection<Document> collection = this.getPatchMdStoreMongoCollection(patchMdStoreId);
            Document mongoQuery = new Document().append("id", (Object)record.getId());
            Document storePatches = (Document)collection.find((Bson)mongoQuery).first();
            if (storePatches == null) {
                Document patched_document = mongoQuery.append("body", (Object)record.asXML()).append("timestamp", (Object)System.currentTimeMillis());
                collection.insertOne((Object)patched_document);
            } else {
                String oldPatches = storePatches.getString((Object)"body");
                collection.findOneAndUpdate((Bson)mongoQuery, (Bson)new Document("$set", (Object)new Document("body", (Object)this.mergePatches(record.asXML(), oldPatches))));
            }
            log.info((Object)("Committed patches on patchMdStoreId " + patchMdStoreId));
        }
        catch (Throwable e) {
            throw new PatchEditorException(e);
        }
    }

    public String mergePatches(String newPatch, String oldPatches) {
        try {
            org.dom4j.Document newDoc = this.reader.read((Reader)new StringReader(newPatch));
            org.dom4j.Document oldDoc = this.reader.read((Reader)new StringReader(oldPatches));
            Element e = (Element)oldDoc.selectSingleNode("//patches");
            for (Object o : newDoc.selectNodes("//patch")) {
                e.add(((Element)o).createCopy());
            }
            oldDoc.selectSingleNode("//*[local-name()='dateOfCollection']").setText(DateUtils.now_ISO8601());
            return oldDoc.asXML();
        }
        catch (Exception e) {
            return newPatch;
        }
    }

    private String getPatchMDStoreId(String repositoryId) throws ISLookUpException {
        String getPatchMdstoreIdQuery = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return $x//PARAM[./@name='patchMdstoreId']/text()";
        ISLookUpService lookUpClient = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List patchMdStoreIds = lookUpClient.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return $x//PARAM[./@name='patchMdstoreId']/text()", repositoryId));
        if (patchMdStoreIds == null || patchMdStoreIds.size() != 1) {
            throw new RuntimeException("Unexpected number of result executing query " + String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return $x//PARAM[./@name='patchMdstoreId']/text()", patchMdStoreIds.get(0)) + " expected: 1");
        }
        return (String)patchMdStoreIds.get(0);
    }

    private MongoCollection<Document> getPatchMdStoreMongoCollection(String mdStoreId) throws MDStoreServiceException {
        MDStoreManagerInfo info = this.mdstoreTransactionManager.getInfoForCurrentMdStore(mdStoreId);
        return this.mdstoreTransactionManager.getDb().getCollection(info.getCurrentId());
    }

    private String retrieveOldPatchesXml(String repositoryId, String recordId) throws PatchEditorException {
        try {
            String patchMdStoreId = this.getPatchMDStoreId(repositoryId);
            MongoCollection<Document> collection = this.getPatchMdStoreMongoCollection(patchMdStoreId);
            Document mongoQuery = new Document().append("id", (Object)recordId);
            Document storePatches = (Document)collection.find((Bson)mongoQuery).first();
            if (storePatches != null) {
                String oldPatches = storePatches.getString((Object)"body");
                return oldPatches;
            }
        }
        catch (MDStoreServiceException | ISLookUpException e) {
            throw new PatchEditorException(e);
        }
        return "";
    }

    private String getLastIndexDate(String repositoryId) throws ISLookUpException {
        String getWorkflowIdQuery = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return  $x//RESOURCE_IDENTIFIER/@value/string()";
        ISLookUpService lookUpClient = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List workflowId = lookUpClient.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return  $x//RESOURCE_IDENTIFIER/@value/string()", repositoryId));
        if (workflowId == null || workflowId.size() != 1) {
            throw new RuntimeException("Unexpected number of result executing query " + String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where ($x//DATASOURCE/@id/string()='%s') return  $x//RESOURCE_IDENTIFIER/@value/string()", repositoryId) + " expected: 1");
        }
        String wfId = (String)workflowId.get(0);
        List subWfs = this.isLookupClient.obtainSubWorkflows(wfId);
        String lastIndexDate = "";
        for (Map map : subWfs) {
            if (!"true".equalsIgnoreCase((String)map.get("isTemplate")) || !"index".equalsIgnoreCase((String)map.get("name"))) continue;
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("system:parentProfileId", wfId);
            query.put("system:profileTemplateId", (String)map.get("id"));
            Map log = this.dnetLogger.findOne(query);
            if (log == null || log.isEmpty()) continue;
            lastIndexDate = (String)log.get("system:endDate");
        }
        return lastIndexDate;
    }

    private boolean existOneNotIndexedPatch(String storedPatches, String lastIndexDatePlain) throws DocumentException {
        DateUtils dateUtils = new DateUtils();
        Date lastIndexDate = dateUtils.parse(DateUtils.calculate_ISO8601((long)Long.parseLong(lastIndexDatePlain)));
        SAXReader reader = new SAXReader();
        org.dom4j.Document patchesDoc = reader.read((Reader)new StringReader(storedPatches));
        for (Object o : patchesDoc.selectNodes("//patch")) {
            Date creationDate;
            String xpath = ((Element)o).valueOf("@xpath");
            String value = ((Element)o).valueOf("@value");
            String creationDatePlain = ((Element)o).valueOf("@creationDate");
            if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{creationDatePlain}) || !(creationDate = dateUtils.parse(creationDatePlain)).after(lastIndexDate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existPatchNotIndexed(String repositoryId, String recordId) throws PatchEditorException {
        String oldPatchesXml = this.retrieveOldPatchesXml(repositoryId, recordId);
        if (StringUtils.isEmpty((CharSequence)oldPatchesXml)) {
            log.info((Object)("No patches found for recordId: " + recordId + " on repositoryId: " + repositoryId));
            return false;
        }
        log.info((Object)("Patches found for recordId: " + recordId + " on repositoryId: " + repositoryId));
        String lastIndexDate = null;
        try {
            lastIndexDate = this.getLastIndexDate(repositoryId);
            boolean found = this.existOneNotIndexedPatch(oldPatchesXml, lastIndexDate);
            if (found) {
                log.info((Object)"Found not indexed patches");
            }
            return found;
        }
        catch (ISLookUpException | DocumentException e) {
            throw new PatchEditorException(e);
        }
    }
}

