/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.model;

import com.google.gson.Gson;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractResolvedObject
implements ResolvedObject {
    protected static final Gson g = new Gson();
    protected String pid;
    protected String pidType;
    protected List<ObjectProvenance> datasourceProvenance;

    @Override
    public String getPid() {
        return this.pid;
    }

    @Override
    public ResolvedObject setPid(String pid) {
        this.pid = pid;
        return this;
    }

    public String getEscapedXMLPid() {
        return StringEscapeUtils.escapeXml11((String)this.pid);
    }

    @Override
    public String getPidType() {
        return this.pidType;
    }

    @Override
    public ResolvedObject setPidType(String pidType) {
        this.pidType = pidType;
        return this;
    }

    @Override
    public String getIdentifier() {
        if (StringUtils.isBlank((CharSequence)this.pid) || StringUtils.isBlank((CharSequence)this.pidType)) {
            throw new RuntimeException("Error pid or pidType cannot be null");
        }
        return DnetXsltFunctions.md5((String)String.format("%s::%s", this.pid.trim().toLowerCase(), this.pidType.toLowerCase().trim()));
    }

    @Override
    public String toJsonString() {
        return g.toJson((Object)this);
    }

    @Override
    public List<ObjectProvenance> getDatasourceProvenance() {
        return this.datasourceProvenance;
    }

    @Override
    public ResolvedObject setDatasourceProvenance(List<ObjectProvenance> datasourceProvenance) {
        this.datasourceProvenance = datasourceProvenance;
        return this;
    }
}

