/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.lang3.StringEscapeUtils;

public class PID {
    private static Gson g = new GsonBuilder().setPrettyPrinting().create();
    private String id;
    private String type;
    private String resolvedUrl;

    public PID() {
    }

    public static PID createPIDfromType(String type, String id) {
        return new PID(id, type);
    }

    public PID(String id, String type) {
        if (id != null) {
            this.id = id.replace("http://dx.doi.org/", "").toLowerCase();
        }
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id != null) {
            this.id = id.replace("http://dx.doi.org/", "").toLowerCase();
        }
    }

    public String getEscapeXMLId() {
        return StringEscapeUtils.escapeXml11((String)this.id);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type != null ? type.toUpperCase() : type;
    }

    public String getResolvedUrl() {
        return this.resolvedUrl;
    }

    public String getResolvedUrlEscaped() {
        return StringEscapeUtils.escapeXml11((String)this.resolvedUrl);
    }

    public void setResolvedUrl(String resolvedUrl) {
        this.resolvedUrl = resolvedUrl;
    }

    public String toString() {
        return g.toJson((Object)this);
    }
}

