package eu.dnetlib.pid.resolver.mdstore.plugin;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import groovy.transform.Synchronized;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.time.LocalDateTime;

public abstract class AbstractResolverSerializer implements ResolverSerializer {

    protected static final Log log = LogFactory.getLog(AbstractResolverSerializer.class);

    @Override
    public String serialize(final StringTemplate template, final ResolvedObject object, final StringWriter writer, final NoIndentWriter out) {
        try {
            template.removeAttribute("object");
            template.setAttribute("object", object);
            template.write(out);
            String result = writer.toString();
            writer.close();
            return result;
        } catch (Throwable e) {

            throw new RuntimeException(object.toJsonString());
        }
    }


    public String serializeReplacingXML(final String xml, final ResolvedObject object, final String objIdentifier, final String recordIdentifier) {
        try {
            VTDGen vg = new VTDGen(); // Instantiate VTDGen
            XMLModifier xm = new XMLModifier(); //Instantiate XMLModifier

            vg.setDoc(xml.getBytes());

            vg.parse(true);
            VTDNav vn = vg.getNav();
            xm.bind(vn);

            final AutoPilot ap = new AutoPilot(vn);

            ap.selectXPath("//*[local-name()='objIdentifier']");
            if (ap.evalXPath()  != -1) {
                if (StringUtils.isNotEmpty(objIdentifier)){
                    int p = vn.getText();
                    xm.updateToken(p, objIdentifier);
                }
                LocalDateTime currentTime = LocalDateTime.now();
                xm.insertAfterElement(String.format("\n<dri:resolvedDate>%s</dri:resolvedDate>", currentTime));
            }

            if (StringUtils.isNotEmpty(recordIdentifier)) {
                ap.selectXPath("//*[local-name()='recordIdentifier']");
                if (ap.evalXPath() != -1) {
                    int p = vn.getText();
                    xm.updateToken(p, recordIdentifier);
                }
            }
            ap.selectXPath("//*[local-name()='about']");
            if (ap.evalXPath() != -1) {
                xm.remove();
            }
            ap.selectXPath("//*[local-name()='metadata']");

            if (ap.evalXPath() != -1) {
                xm.insertBeforeElement(serializeToXML(object));
                xm.remove();
            }
            final ByteArrayOutputStream bas = new ByteArrayOutputStream();
            xm.output(bas);
            return new String(bas.toByteArray());
        } catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Error on replacing xml: %s", xml));
            }
            return null;
        }
    }

    public String serializeReplacingXML(final String xml, final ResolvedObject object) {
        return serializeReplacingXML(xml, object, null, null);
    }

}
