package eu.dnetlib.pid.resolver.model;

import com.google.gson.Gson;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

public abstract class AbstractResolvedObject implements ResolvedObject {
    protected static final Gson g = new Gson();
    /**
     * The doi.
     */
    protected String pid;
    /**
     * The pid type.
     */
    protected String pidType;

    /**
     * The datasources.
     */
    protected List<ObjectProvenance> datasourceProvenance;


    @Override
    public String getPid() {
        return pid;
    }

    @Override
    public ResolvedObject setPid(String pid) {
        this.pid = pid;
        return this;
    }


    public String getEscapedXMLPid() {
        return StringEscapeUtils.escapeXml11(this.pid);
    }

    @Override
    public String getPidType() {
        return pidType;
    }

    @Override
    public ResolvedObject setPidType(String pidType) {
        this.pidType = pidType;
        return this;
    }

    /**
     * Gets the identifier. with the form of MD5(pid::pidType)
     *
     * @return the identifier
     */
    @Override
    public String getIdentifier() {
        if (StringUtils.isBlank(pid) || StringUtils.isBlank(pidType))
            throw new RuntimeException("Error pid or pidType cannot be null");
        return DnetXsltFunctions.md5(String.format("%s::%s", pid.trim().toLowerCase(), pidType.toLowerCase().trim()));
    }

    @Override
    public String toJsonString() {
        return g.toJson(this);
    }


    @Override
    public List<ObjectProvenance> getDatasourceProvenance() {
        return datasourceProvenance;
    }


    @Override
    public ResolvedObject setDatasourceProvenance(final List<ObjectProvenance> datasourceProvenance) {
        this.datasourceProvenance = datasourceProvenance;
        return this;
    }
}
