/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.mdstore.plugin;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.time.LocalDateTime;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractResolverSerializer
implements ResolverSerializer {
    protected static final Log log = LogFactory.getLog(AbstractResolverSerializer.class);

    @Override
    public String serialize(StringTemplate template, ResolvedObject object, StringWriter writer, NoIndentWriter out) {
        try {
            template.removeAttribute("object");
            template.setAttribute("object", (Object)object);
            template.write((StringTemplateWriter)out);
            String result = writer.toString();
            writer.close();
            return result;
        }
        catch (Throwable e) {
            throw new RuntimeException(object.toJsonString());
        }
    }

    public String serializeReplacingXML(String xml, ResolvedObject object, String objIdentifier, String recordIdentifier) {
        try {
            VTDGen vg = new VTDGen();
            XMLModifier xm = new XMLModifier();
            vg.setDoc(xml.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            xm.bind(vn);
            AutoPilot ap = new AutoPilot(vn);
            ap.selectXPath("//*[local-name()='objIdentifier']");
            if (ap.evalXPath() != -1) {
                if (StringUtils.isNotEmpty((CharSequence)objIdentifier)) {
                    int p = vn.getText();
                    xm.updateToken(p, objIdentifier);
                }
                LocalDateTime currentTime = LocalDateTime.now();
                xm.insertAfterElement(String.format("\n<dri:resolvedDate>%s</dri:resolvedDate>", currentTime));
            }
            if (StringUtils.isNotEmpty((CharSequence)recordIdentifier)) {
                ap.selectXPath("//*[local-name()='recordIdentifier']");
                if (ap.evalXPath() != -1) {
                    int p = vn.getText();
                    xm.updateToken(p, recordIdentifier);
                }
            }
            ap.selectXPath("//*[local-name()='about']");
            if (ap.evalXPath() != -1) {
                xm.remove();
            }
            ap.selectXPath("//*[local-name()='metadata']");
            if (ap.evalXPath() != -1) {
                xm.insertBeforeElement(this.serializeToXML(object));
                xm.remove();
            }
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            xm.output((OutputStream)bas);
            return new String(bas.toByteArray());
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Error on replacing xml: %s", xml));
            }
            return null;
        }
    }

    @Override
    public String serializeReplacingXML(String xml, ResolvedObject object) {
        return this.serializeReplacingXML(xml, object, null, null);
    }
}

