package eu.dnetlib.pid.resolver.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * The Class PID.
 */
public class PID {

    private static Gson g = new GsonBuilder().setPrettyPrinting().create();

    /**
     * The id.
     */
    private String id;

    /**
     * The type.
     */
    private String type;



    private String resolvedUrl;

    /**
     * Instantiates a new pid.
     */
    public PID() {

    }

    public static PID createPIDfromType(final String type, final String id) {
        return new PID(id, type);
    }

    /**
     * Instantiates a new pid.
     *
     * @param id   the id
     * @param type the type
     */
    public PID(final String id, final String type) {
        if (id != null) {
            this.id = id.replace("http://dx.doi.org/", "").toLowerCase();
        }
        this.type = type;
    }

    /**
     * Gets the id.
     *
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id to set
     */
    public void setId(final String id) {
        if (id != null) {
            this.id = id.replace("http://dx.doi.org/", "").toLowerCase();
        }
        ;
    }

    public String getEscapeXMLId() {
        return StringEscapeUtils.escapeXml11(id);
    }

    /**
     * Gets the type.
     *
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the type.
     *
     * @param type the type to set
     */
    public void setType(final String type) {
        if (type != null) {
            this.type = type.toUpperCase();
        } else {
            this.type = type;
        }
    }

    public String getResolvedUrl() {
        return resolvedUrl;
    }

    public String getResolvedUrlEscaped() {
        return StringEscapeUtils.escapeXml11(resolvedUrl);
    }

    public void setResolvedUrl(String resolvedUrl) {
        this.resolvedUrl = resolvedUrl;
    }



    @Override
    public String toString() {
        return g.toJson(this);
    }
}
