package eu.dnetlib.pid.resolver.model;

import java.util.List;

public interface ResolvedObject {

    String getPid();

    ResolvedObject setPid(String pid);

    String getPidType();

    ResolvedObject setPidType(String pidType);

    String getIdentifier();

    ObjectType getType();

    ResolvedObject setType(ObjectType Type);

    String toJsonString();

    List<ObjectRelation> getRelations();

    /**
     * Gets the datasource provenance.
     *
     * @return the datasource provenance
     */
    List<ObjectProvenance> getDatasourceProvenance();

    /**
     * Sets the datasource provenance.
     *
     * @param datasourceProvenance the new datasource provenance
     */
    ResolvedObject setDatasourceProvenance(final List<ObjectProvenance> datasourceProvenance);

    ResolvedObject setSubjects(List<SubjectType> subjectResult);
}
