package eu.dnetlib.pid.workflows.nodes;


import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;
import eu.dnetlib.pid.resolver.store.ResolverStore;
import eu.dnetlib.rmi.common.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by sandro on 10/11/16.
 */
public class FilterResolvedRecordJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FilterResolvedRecordJobNode.class);

	private final static String recordTemplate =
			"<root xmlns:oaf=\"http://namespace.dnet.eu/oaf\" xmlns:dri=\"http://www.driver-repository.eu/namespace/dri\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">%s</root>";

	private String type;

	private String eprParam;

	@Autowired
	private ResolverStore resolverStore;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Autowired
    private ResolverSerializer resolverSerializer;

	@Override
	protected String execute(final Env env) throws Exception {
		final Iterable<String> resultIterator = DnetStreamSupport.generateStreamFromIterator(resolverStore.getAllRecords(type).iterator())
				.map(record -> String.format(recordTemplate, resolverSerializer.serializeToXML(record)))::iterator;
		final ResultSet<String> resultSet = resultSetFactory.createResultSet(resultIterator);
		env.setAttribute(eprParam, resultSet);
		return Arc.DEFAULT_ARC;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}
}
