/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver;

import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.store.ResolverStore;
import java.io.IOException;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractPIDResolver
implements PIDResolver {
    private static final Log log = LogFactory.getLog(AbstractPIDResolver.class);
    private Cache cache;
    protected String name;
    protected int order;
    protected boolean availableOffline;
    @Autowired
    private ResolverStore storeManager;
    private static ResponseHandler<String> responseHandler = response -> {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        log.debug((Object)("Unexpected response status: " + status));
        return null;
    };

    @Override
    public ResolvedObject retrievePIDfromCache(String pid, String pidType) {
        String dnetIdentifier = this.storeManager.generateDNetIdentifier(pid, pidType);
        Element item = this.cache.get((Serializable)((Object)dnetIdentifier));
        if (item != null) {
            return (ResolvedObject)item.getObjectValue();
        }
        return this.storeManager.getRecord(dnetIdentifier);
    }

    @Override
    public ResolvedObject retrievePID(String pid, String pidType, boolean offline) {
        if (offline && !this.isAvailableOffline()) {
            return null;
        }
        if (!this.canResolvePid(pidType)) {
            return null;
        }
        String dnetIdentifier = this.storeManager.generateDNetIdentifier(pid, pidType);
        Element item = this.cache.get((Serializable)((Object)dnetIdentifier));
        if (item != null) {
            return (ResolvedObject)item.getObjectValue();
        }
        ResolvedObject resolvedObject = this.storeManager.getRecord(dnetIdentifier);
        if (resolvedObject != null) {
            this.cache.put(new Element((Object)this.storeManager.generateDNetIdentifier(pid, pidType), (Object)resolvedObject));
            return resolvedObject;
        }
        log.debug((Object)("Cache miss for pid:" + pid + "  and type :" + pidType));
        resolvedObject = this.resolve(pid, pidType);
        if (resolvedObject != null) {
            this.storeManager.insertRecord(this.getName(), resolvedObject);
            this.cache.put(new Element((Object)this.storeManager.generateDNetIdentifier(pid, pidType), (Object)resolvedObject));
            return resolvedObject;
        }
        return null;
    }

    @Override
    public String retrieveDnetID(String pid, String pidType, boolean offline) {
        if (offline && !this.isAvailableOffline()) {
            return null;
        }
        if (!this.canResolvePid(pidType)) {
            return null;
        }
        String dnetIdentifier = this.storeManager.generateDNetIdentifier(pid, pidType);
        Element item = this.cache.get((Serializable)((Object)dnetIdentifier));
        if (item != null) {
            return dnetIdentifier;
        }
        String resolvedIdentifier = this.storeManager.getRecordIdentifier(dnetIdentifier);
        if (resolvedIdentifier != null && !StringUtils.isBlank((CharSequence)resolvedIdentifier)) {
            return resolvedIdentifier;
        }
        ResolvedObject resolvedObject = this.resolve(pid, pidType);
        if (resolvedObject != null) {
            this.storeManager.insertRecord(this.getName(), resolvedObject);
            this.cache.put(new Element((Object)dnetIdentifier, (Object)resolvedObject));
            return dnetIdentifier;
        }
        return null;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract boolean canResolvePid(String var1);

    protected abstract ResolvedObject resolve(String var1, String var2);

    public Cache getCache() {
        return this.cache;
    }

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestURL(String url, int timeout, int numberOfRetry) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        log.debug((Object)("Timeout: " + timeout));
        CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        try {
            String string = AbstractPIDResolver.getRequest(url, httpclient, numberOfRetry);
            return string;
        }
        catch (Throwable e) {
            log.debug((Object)("Error in getting url " + url), e);
            String string = null;
            return string;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                log.error((Object)"Error on closing httpclient", (Throwable)e);
            }
        }
    }

    public static String requestURL(String url) {
        return AbstractPIDResolver.requestURL(url, 4, 1);
    }

    private static String getRequest(String url, CloseableHttpClient httpclient, int numberOfRetry) {
        try {
            log.debug((Object)("requesting URL: " + url));
            HttpGet httpGet = new HttpGet(url);
            return (String)httpclient.execute((HttpUriRequest)httpGet, responseHandler);
        }
        catch (Exception e) {
            log.debug((Object)("Error in getting url " + url), (Throwable)e);
            if (numberOfRetry > 0) {
                log.debug((Object)"Try again");
                return AbstractPIDResolver.getRequest(url, httpclient, --numberOfRetry);
            }
            return null;
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Required
    public AbstractPIDResolver setOrder(int order) {
        this.order = order;
        return this;
    }

    @Override
    public int compareTo(PIDResolver o) {
        return Integer.compare(this.getOrder(), o.getOrder());
    }

    public boolean isAvailableOffline() {
        return this.availableOffline;
    }

    @Required
    public AbstractPIDResolver setAvailableOffline(boolean availableOffline) {
        this.availableOffline = availableOffline;
        return this;
    }
}

