package eu.dnetlib.pid.resolver;


import eu.dnetlib.pid.resolver.model.ResolvedObject;

/**
 * The Interface DOIResolver.
 */
public interface PIDResolver extends Comparable<PIDResolver> {


	int getOrder();

	/**
     * Resolve The Object with the following pid.
     *
	 * @param pid     the persistent identifier to resolve
	 * @param pidType the type of persistent identifier to resolve
	 * @return the DLIObject resolved if exists, null otherwise
	 */
	ResolvedObject retrievePID(final String pid, final String pidType, final boolean offline);


	/**
	 * Retrieve PID only from cache and not trying to resolve it
	 *
	 * @param pid     the persistent identifier to resolve
	 * @param pidType the type of persistent identifier to resolve
	 * @return the DLIObject resolved if exists, null otherwise
	 */
	ResolvedObject retrievePIDfromCache(final String pid, final String pidType);

	/**
	 * Resolve and return the Dnet Identifier
	 *
	 * @param pid     the persistent identifier to rescolve
	 * @param pidType the type of persistent identifier to resolve
	 * @return the Dnet Identifier of the DLI Object resolved if exists, null otherwise
	 */

	String retrieveDnetID(final String pid, final String pidType, final boolean offline);




}
