package eu.dnetlib.pid.resolver.mdstore.plugin;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.pid.resolver.PIDResolver;
import org.antlr.stringtemplate.StringTemplate;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

public interface RecordResolver extends Callable<Boolean> {

    String resolve(final String inputRecord);

//    void setTemplate(final StringTemplate template);

    void setPluginResolver(final List<PIDResolver> pluginResolver);

    BlockingQueue<DBObject> getInputQueue();

    void setInputQueue(final BlockingQueue<DBObject> inputQueue);

    MongoCollection<DBObject> getOutputCollection();

    void setOutputCollection(final MongoCollection<DBObject> outputCollection);

    void setSerializer(final ResolverSerializer serializer);
}
