/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.model.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ResolvedObjectDeserializer
implements JsonDeserializer<ResolvedObject> {
    private static final Log log = LogFactory.getLog(ResolvedObjectDeserializer.class);

    protected void partialDeserialization(JsonObject root, ResolvedObject resolvedObject) {
        log.debug((Object)"called partialDeserialization");
        try {
            JsonElement pid = root.get("pid");
            resolvedObject.setPid(pid != null ? pid.getAsString() : "");
            JsonElement pidType = root.get("pidType");
            resolvedObject.setPidType(pidType != null ? pidType.getAsString() : "");
            JsonElement type = root.get("type");
            if (type != null) {
                switch (type.getAsString()) {
                    case "dataset": {
                        resolvedObject.setType(ObjectType.dataset);
                        break;
                    }
                    case "publication": {
                        resolvedObject.setType(ObjectType.publication);
                        break;
                    }
                    default: {
                        resolvedObject.setType(ObjectType.unknown);
                    }
                }
            }
            if (root.has("subjects") && root.get("subjects").isJsonArray()) {
                JsonArray subjects = root.getAsJsonArray("subjects");
                ArrayList<SubjectType> extractedSubjects = new ArrayList<SubjectType>();
                if (subjects != null) {
                    subjects.forEach(sub -> {
                        JsonObject subject;
                        if (sub.isJsonObject() && (subject = sub.getAsJsonObject()).has("scheme") && subject.has("term")) {
                            extractedSubjects.add(new SubjectType(subject.get("scheme").getAsString(), subject.get("term").getAsString()));
                        }
                    });
                }
                resolvedObject.setSubjects(extractedSubjects);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error  on deserialize " + root), e);
        }
    }

    protected String getValue(JsonObject input, String field) {
        return input.has(field) ? input.get(field).getAsString() : "";
    }

    protected List<String> extractListValues(JsonObject root, String field) {
        ArrayList<String> output = new ArrayList<String>();
        if (root != null && !root.isJsonNull() && root.has(field) && root.get(field).isJsonArray()) {
            root.getAsJsonArray(field).forEach(it -> {
                if (it != null && !it.isJsonNull()) {
                    output.add(it.getAsString());
                }
            });
        }
        return output;
    }
}

