/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.store;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.factory.ResolvedObjectFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;

public class ResolverStore {
    private static final Log log = LogFactory.getLog(ResolverStore.class);
    @Value(value="${services.pid.resolver.header}")
    private String ns_header;
    private static List<String> requirededIndex = new ArrayList<String>(Arrays.asList("pid", "pid_type", "resolver", "dnet_identifier", "typology"));
    private final UpdateOptions upsert = new UpdateOptions().upsert(true);
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoCollection<DBObject> resolverCollection;
    private String collectionName;
    private String databaseName;
    @Autowired
    private ResolvedObjectFactory objectFactory;

    public void checkIntegrityCollection() {
        this.getMongoDatabase().getCollection(this.collectionName);
        MongoCollection collection = this.getMongoDatabase().getCollection(this.collectionName, DBObject.class);
        List idxName = StreamSupport.stream(collection.listIndexes().spliterator(), false).map(document -> (String)((Document)document.get((Object)"key")).keySet().iterator().next()).collect(Collectors.toList());
        List toAdd = requirededIndex.stream().filter(it -> !idxName.contains(it)).collect(Collectors.toList());
        for (String idx : toAdd) {
            log.debug((Object)("Adding " + idx + " index"));
            collection.createIndex((Bson)new Document(idx, (Object)1));
        }
        this.resolverCollection = collection;
    }

    public List<String> getIndexName() {
        return StreamSupport.stream(this.resolverCollection.listIndexes().spliterator(), false).map(document -> (String)((Document)document.get((Object)"key")).keySet().iterator().next()).collect(Collectors.toList());
    }

    public void insertRecord(String resolver, ResolvedObject resolvedObject) {
        if (this.resolverCollection == null) {
            this.checkIntegrityCollection();
        }
        DBObject currentObject = BasicDBObjectBuilder.start().add("pid", (Object)resolvedObject.getPid().toLowerCase()).add("pid_type", (Object)resolvedObject.getPidType().toLowerCase()).add("dnet_identifier", (Object)this.generateDNetIdentifier(resolvedObject)).add("resolver", (Object)resolver).add("typology", (Object)resolvedObject.getType().toString()).add("body", (Object)resolvedObject.toJsonString()).get();
        Bson dnet_identifier = (Bson)BasicDBObjectBuilder.start().add("dnet_identifier", (Object)(this.ns_header + resolvedObject.getIdentifier())).get();
        this.resolverCollection.replaceOne(dnet_identifier, (Object)currentObject, this.upsert);
    }

    public String generateDNetIdentifier(String pid, String pidType) {
        if (StringUtils.isBlank((CharSequence)pid) || StringUtils.isBlank((CharSequence)pidType)) {
            log.error((Object)"Error pid or pidtype cannot be null");
            return null;
        }
        return this.ns_header + DnetXsltFunctions.md5((String)String.format("%s::%s", pid.trim().toLowerCase(), pidType.toLowerCase().trim()));
    }

    public String generateDNetIdentifier(ResolvedObject object) {
        return this.ns_header + object.getIdentifier();
    }

    public void insertRecords(String resolver, List<ResolvedObject> resolvedObjects) {
        resolvedObjects.forEach(it -> this.insertRecord(resolver, (ResolvedObject)it));
    }

    public ResolvedObject getRecord(String dnetIdentifier) {
        MongoCursor iterator;
        Bson query;
        FindIterable dbObjects;
        if (this.resolverCollection == null) {
            this.checkIntegrityCollection();
        }
        if ((dbObjects = this.resolverCollection.find(query = (Bson)QueryBuilder.start((String)"dnet_identifier").is((Object)dnetIdentifier).get())) != null && (iterator = dbObjects.iterator()).hasNext()) {
            String body = ((DBObject)iterator.next()).get("body").toString();
            ResolvedObject obj = this.objectFactory.generateObjectFromJson(body);
            return obj;
        }
        return null;
    }

    public ResolvedObject getRecord(String pid, String pidType) {
        Bson query;
        FindIterable dbObjects;
        if (this.resolverCollection == null) {
            this.checkIntegrityCollection();
        }
        if ((dbObjects = this.resolverCollection.find(query = (Bson)QueryBuilder.start((String)"pid").is((Object)pid.toLowerCase()).and("pid_type").is((Object)pidType.toLowerCase()).get())) != null) {
            ArrayList rList = new ArrayList();
            dbObjects.forEach(it -> {
                String body = it.get("body").toString();
                ResolvedObject obj = this.objectFactory.generateObjectFromJson(it.get("body").toString());
                rList.add(obj);
            });
            if (rList.size() > 0) {
                return (ResolvedObject)rList.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecordIdentifier(String dnetId) {
        double start = 0.0;
        try {
            if (this.resolverCollection == null) {
                this.checkIntegrityCollection();
            }
            start = System.currentTimeMillis();
            Bson query = (Bson)QueryBuilder.start().put("dnet_identifier").is((Object)dnetId).get();
            FindIterable dbObjects = this.resolverCollection.find(query);
            if (dbObjects != null && dbObjects.iterator().hasNext()) {
                String string = dnetId;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            double total = (double)System.currentTimeMillis() - start;
            log.debug((Object)("Request fetched in " + total + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecordIdentifier(String pid, String pidType) {
        double start = 0.0;
        try {
            if (this.resolverCollection == null) {
                this.checkIntegrityCollection();
            }
            start = System.currentTimeMillis();
            Bson query = (Bson)QueryBuilder.start().put("pid").is((Object)pid).and("pid_type").is((Object)pidType).get();
            FindIterable dbObjects = this.resolverCollection.find(query);
            if (dbObjects != null) {
                for (DBObject obj : dbObjects) {
                    String id = obj.get("dnet_identifier").toString();
                    if (id == null || StringUtils.isBlank((CharSequence)id)) continue;
                    String string = id;
                    return string;
                }
            }
            MongoCursor mongoCursor = null;
            return mongoCursor;
        }
        finally {
            double total = (double)System.currentTimeMillis() - start;
            log.debug((Object)("Request fetched in " + total + " ms"));
        }
    }

    public Iterable<ResolvedObject> getAllRecords() {
        try {
            if (this.resolverCollection == null) {
                this.checkIntegrityCollection();
            }
            FindIterable dbObjects = this.resolverCollection.find();
            return () -> DnetStreamSupport.generateStreamFromIterator((Iterator)dbObjects.iterator()).map(it -> this.objectFactory.generateObjectFromJson(it.get("body").toString())).iterator();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Iterable<ResolvedObject> getAllRecords(String type) {
        try {
            if (this.resolverCollection == null) {
                this.checkIntegrityCollection();
            }
            DBObject query = QueryBuilder.start((String)"typology").is((Object)type).get();
            FindIterable dbObjects = this.resolverCollection.find((Bson)query);
            return () -> DnetStreamSupport.generateStreamFromIterator((Iterator)dbObjects.iterator()).map(it -> this.objectFactory.generateObjectFromJson(it.get("body").toString())).iterator();
        }
        catch (Exception e) {
            return null;
        }
    }

    public MongoDatabase getMongoDatabase() {
        if (this.mongoDatabase == null) {
            this.mongoDatabase = this.mongoClient.getDatabase(this.getDatabaseName());
        }
        return this.mongoDatabase;
    }

    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public MongoCollection<DBObject> getResolverCollection() {
        return this.resolverCollection;
    }

    public void setResolverCollection(MongoCollection<DBObject> resolverCollection) {
        this.resolverCollection = resolverCollection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Required
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Required
    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }
}

