package eu.dnetlib.pid.resolver.model;

/**
 * Created by sandro on 9/16/16.
 */

import org.apache.commons.lang3.StringEscapeUtils;

/**
 * The subject class represent a typical subject for the resolved object
 * with a Scheme and Term
 */
public class SubjectType {

	private String scheme;

	private String term;

	public SubjectType() {
	}

	;

	public SubjectType(final String scheme, final String term) {
		this.scheme = scheme;
		this.term = term;
	}

	public String getScheme() {
		return scheme;
	}

	public void setScheme(final String scheme) {
		this.scheme = scheme;
	}

	public String getEscapedTerm() {
		return this.term != null ? StringEscapeUtils.escapeXml11(this.term) : null;
	}

	public String getEscapedScheme() {
		return this.scheme != null ? StringEscapeUtils.escapeXml11(this.scheme) : null;
	}

	public String getTerm() {
		return term;
	}

	public void setTerm(final String term) {
		this.term = term;
	}

	@Override
	public String toString() {
		return "Scheme: " + scheme + " Term: " + term;
	}
}
