package eu.dnetlib.pid.workflows.nodes;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.DateProcessUtils;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.data.MDStoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by sandro on 2/22/16.
 */
public class ExecuteMDStorePluginJobNode extends BlackboardJobNode implements ProcessAware {

	private String mdStoreId;

	private String pluginName;

    private String numberOfThreads;

    private boolean offline;

    private String collectionMode;

    private WorkflowProcess process;

    @Autowired
	private DnetLogger dnetLogger;


	public String getPluginName() {
		return this.pluginName;
	}

	public void setPluginName(final String pluginName) {
		this.pluginName = pluginName;
	}

	public String getMdStoreId() {
		return this.mdStoreId;
	}

	public void setMdStoreId(final String mdStoreId) {
		this.mdStoreId = mdStoreId;
	}

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(MDStoreService.class, getMdStoreId());
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction("RUN_PLUGIN");
		job.getParameters().put("plugin.name", getPluginName());
		job.getParameters().put("mdStoreId", getMdStoreId());
        if (!StringUtils.isEmpty(getNumberOfThreads()))
            job.getParameters().put("numberOfThreads", getNumberOfThreads());
        job.getParameters().put("offline", ""+isOffline());
		if (!StringUtils.isEmpty(collectionMode)) {
			final String successDate = DateProcessUtils.getEndDate(process, dnetLogger);
			job.getParameters().put("collectionMode", collectionMode);
			if (successDate!= null) {
				job.getParameters().put("lastResolveDate", successDate);
			}
		}
    }

    public String getNumberOfThreads() {
        return numberOfThreads;
    }

    public void setNumberOfThreads(String numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }


	public boolean isOffline() {
		return offline;
	}

	public ExecuteMDStorePluginJobNode setOffline(boolean offline) {
		this.offline = offline;
		return this;
	}

	public String getCollectionMode() {
		return collectionMode;
	}

	public void setCollectionMode(String collectionMode) {
		this.collectionMode = collectionMode;
	}

	@Override
	public void setProcess(WorkflowProcess workflowProcess) {
		this.process = workflowProcess;
	}
}
