/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.mdstore.plugin;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.RecordResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverMDStorePlugin;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRecordResolver
implements RecordResolver {
    protected static final Log log = LogFactory.getLog(AbstractRecordResolver.class);
    protected final Long timestamp;
    protected List<PIDResolver> pluginResolver;
    protected BlockingQueue<DBObject> inputQueue;
    protected MongoCollection<DBObject> outputCollection;
    protected ResolverSerializer serializer;
    protected boolean offline;
    protected boolean forceResolver = false;

    public AbstractRecordResolver(long ts) {
        this.timestamp = ts;
    }

    protected String resolveRelations(String inputRecord, ResolvedObject inputObject, boolean shouldUpdate, Function<String, String> getInverseRelation) {
        if (inputObject.getRelations() != null) {
            for (ObjectRelation rel : inputObject.getRelations()) {
                Map<String, ObjectType> resolvedRelation = this.tryToResolveRelation(rel.getTargetPID());
                if (resolvedRelation == null || resolvedRelation.isEmpty()) continue;
                resolvedRelation.entrySet().forEach(e -> {
                    rel.setTargetPID(new PID((String)e.getKey(), "dnet"));
                    rel.setTargetType((ObjectType)((Object)((Object)e.getValue())));
                    rel.setInverseRelation((String)getInverseRelation.apply(rel.getRelationSemantics()));
                });
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                String newXML = this.serializer.serializeReplacingXML(inputRecord, inputObject);
                return newXML;
            }
        }
        return null;
    }

    @Override
    public Boolean call() throws Exception {
        log.info((Object)("START HERE! Ressolving offline:" + this.offline));
        DBObject currentObject = this.inputQueue.take();
        int i = 0;
        String currentRecord = null;
        double sumTotal = 0.0;
        while (currentObject != ResolverMDStorePlugin.DONE) {
            try {
                currentRecord = (String)currentObject.get("body");
                if (this.forceResolver || currentObject.get("resolved_ts") == null) {
                    double start = System.currentTimeMillis();
                    String resolvedRecord = this.resolve(currentRecord);
                    if (resolvedRecord != null) {
                        currentObject.put("body", (Object)resolvedRecord);
                        currentObject.removeField("_id");
                        currentObject.put("resolved_ts", (Object)this.timestamp);
                        this.outputCollection.insertOne((Object)currentObject);
                    }
                    double total = (double)System.currentTimeMillis() - start;
                    sumTotal += total;
                }
                currentObject = this.inputQueue.take();
                if (i++ % 100 != 0) continue;
                log.debug((Object)(Thread.currentThread().getId() + " total object resolved: " + i + "in average time " + sumTotal / 100.0 + "ms"));
                sumTotal = 0.0;
            }
            catch (Throwable e) {
                log.error((Object)("Error on resolving objects " + currentRecord), e);
                return false;
            }
        }
        if (currentObject == ResolverMDStorePlugin.DONE) {
            this.inputQueue.put(currentObject);
        }
        return true;
    }

    protected abstract Map<String, ObjectType> tryToResolveRelation(PID var1);

    public void setOffline(boolean offline) {
        this.offline = offline;
    }
}

