/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.resolver.parser;

import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractResolverParser {
    protected static final Log log = LogFactory.getLog(AbstractResolverParser.class);
    static final Pattern pattern = Pattern.compile("10\\.\\d{4,9}/[-._;()/:A-Z0-9]+$", 2);
    private List<String> datasetSubTypes = Arrays.asList("dataset", "software", "film", "sound", "physicalobject", "audiovisual", "collection", "other", "study", "metadata");

    public abstract ResolvedObject parseObject(String var1);

    protected Map<String, String> getAttributes(XMLStreamReader parser) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attributesMap.put(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
        }
        return attributesMap;
    }

    protected void setType(ResolvedObject object, String type) {
        if (!StringUtils.isBlank((CharSequence)type)) {
            if (this.datasetSubTypes.contains(type.toLowerCase())) {
                object.setType(ObjectType.dataset);
                return;
            }
            if (type.toLowerCase().contains("publication")) {
                object.setType(ObjectType.publication);
                return;
            }
            object.setType(ObjectType.unknown);
        }
    }

    protected void extractSubject(ResolvedObject parsedObject, List<VtdUtilityParser.Node> subjects) {
        if (subjects != null && subjects.size() > 0) {
            ArrayList<SubjectType> subjectResult = new ArrayList<SubjectType>();
            subjects.forEach(subjectMap -> {
                SubjectType subject = new SubjectType((String)subjectMap.getAttributes().get("subjectScheme"), subjectMap.getTextValue());
                subjectResult.add(subject);
            });
            parsedObject.setSubjects(subjectResult);
        }
    }

    protected boolean extractIdentifier(ResolvedObject parsedObject, List<VtdUtilityParser.Node> identifierType) {
        return this.extractIdentifier(parsedObject, identifierType, "identifierType");
    }

    protected boolean extractIdentifier(ResolvedObject parsedObject, List<VtdUtilityParser.Node> identifierType, String fieldName) {
        if (identifierType == null || identifierType.size() <= 0) {
            log.debug((Object)"Error on parsing record the identifier should not null ");
            return true;
        }
        VtdUtilityParser.Node result = identifierType.get(0);
        parsedObject.setPid(result.getTextValue());
        parsedObject.setPidType((String)result.getAttributes().get(fieldName));
        return false;
    }

    protected PID inferPid(PID input) {
        Matcher matcher = pattern.matcher(input.getId());
        if (matcher.find()) {
            input.setId(matcher.group());
            input.setType("doi");
        }
        return input;
    }
}

