/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pid.workflows.nodes;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.DateProcessUtils;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.data.MDStoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecuteMDStorePluginJobNode
extends BlackboardJobNode
implements ProcessAware {
    private String mdStoreId;
    private String pluginName;
    private String numberOfThreads;
    private boolean offline;
    private String collectionMode;
    private WorkflowProcess process;
    @Autowired
    private DnetLogger dnetLogger;

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getMdStoreId() {
        return this.mdStoreId;
    }

    public void setMdStoreId(String mdStoreId) {
        this.mdStoreId = mdStoreId;
    }

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(MDStoreService.class, this.getMdStoreId());
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        job.setAction("RUN_PLUGIN");
        job.getParameters().put("plugin.name", this.getPluginName());
        job.getParameters().put("mdStoreId", this.getMdStoreId());
        if (!StringUtils.isEmpty((CharSequence)this.getNumberOfThreads())) {
            job.getParameters().put("numberOfThreads", this.getNumberOfThreads());
        }
        job.getParameters().put("offline", "" + this.isOffline());
        if (!StringUtils.isEmpty((CharSequence)this.collectionMode)) {
            String successDate = DateProcessUtils.getEndDate((WorkflowProcess)this.process, (DnetLogger)this.dnetLogger);
            job.getParameters().put("collectionMode", this.collectionMode);
            if (successDate != null) {
                job.getParameters().put("lastResolveDate", successDate);
            }
        }
    }

    public String getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(String numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public ExecuteMDStorePluginJobNode setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public String getCollectionMode() {
        return this.collectionMode;
    }

    public void setCollectionMode(String collectionMode) {
        this.collectionMode = collectionMode;
    }

    public void setProcess(WorkflowProcess workflowProcess) {
        this.process = workflowProcess;
    }
}

