package eu.dnetlib.pid.resolver.model.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

public abstract class ResolvedObjectDeserializer implements JsonDeserializer<ResolvedObject> {

    private static final Log log = LogFactory.getLog(ResolvedObjectDeserializer.class);

    protected void partialDeserialization(final JsonObject root, final ResolvedObject resolvedObject) {

        log.debug("called partialDeserialization");


        try {
            final JsonElement pid = root.get("pid");
            resolvedObject.setPid(pid != null ? pid.getAsString() : "");
            final JsonElement pidType = root.get("pidType");
            resolvedObject.setPidType(pidType != null ? pidType.getAsString() : "");
            final JsonElement type = root.get("type");
            if (type != null)
                switch (type.getAsString()) {
                    case "dataset":
                        resolvedObject.setType(ObjectType.dataset);
                        break;
                    case "publication":
                        resolvedObject.setType(ObjectType.publication);
                        break;
                    default:
                        resolvedObject.setType(ObjectType.unknown);
                        break;
                }
            if (root.has("subjects") && root.get("subjects").isJsonArray()) {
                final JsonArray subjects = root.getAsJsonArray("subjects");
                final List<SubjectType> extractedSubjects = new ArrayList<>();
                if (subjects != null)
                    subjects.forEach(sub -> {
                        if (sub.isJsonObject()) {
                            final JsonObject subject = sub.getAsJsonObject();
                            if (subject.has("scheme") && subject.has("term"))
                                extractedSubjects.add(new SubjectType(subject.get("scheme").getAsString(), subject.get("term").getAsString()));
                        }
                    });
                resolvedObject.setSubjects(extractedSubjects);
            }
        } catch (Throwable e) {
            log.error("Error  on deserialize " + root, e);
        }
    }


    protected String getValue(final JsonObject input, final String field) {
        return input.has(field) ? input.get(field).getAsString() : "";
    }

    protected List<String> extractListValues(final JsonObject root, final String field) {
        final List<String> output = new ArrayList<>();
        if (root != null && !root.isJsonNull() && root.has(field) && root.get(field).isJsonArray()) {
            root.getAsJsonArray(field)
                    .forEach(it -> {
                        if (it != null && !it.isJsonNull())
                            output.add(it.getAsString());
                    });
        }
        return output;


    }
}
