/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.proto;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WDSIndexItemProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import eu.dnetlib.data.proto.WdsPublicationProtos;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DNGFWDSIndexConverter {
    public WDSIndexItemProtos.Item.Builder convert(DNGFProtos.DNGF mainDNGFEntity) {
        if (!this.isValid(mainDNGFEntity)) {
            return null;
        }
        DNGFProtos.DNGFEntity entity = mainDNGFEntity.getEntity();
        WDSIndexItemProtos.Item.Builder indexItem = WDSIndexItemProtos.Item.newBuilder();
        TypeProtos.Type itemType = entity.getType();
        indexItem.setId(entity.getId());
        this.addIdentifier(indexItem, entity.getPidList());
        indexItem.setDateofcollection(entity.getDateofcollection());
        switch (itemType) {
            case dataset: {
                this.setDatasetValues(entity, indexItem);
                break;
            }
            case publication: {
                this.setPublicationValues(entity, indexItem);
            }
        }
        return indexItem;
    }

    public void addRelation(WDSIndexItemProtos.Item.Builder item, DNGFProtos.DNGFRel rel) {
        WDSIndexItemProtos.RelationType.Builder currentRel = WDSIndexItemProtos.RelationType.newBuilder();
        RelDescriptor relDescriptor = DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel).getRelDescriptor();
        currentRel.setSemantic(relDescriptor.getTermCode());
        currentRel.setId(WDSIndexItemProtos.Identifier.newBuilder().setId(relDescriptor.getTargetId()).setType("dnet").build());
        item.addRelations(currentRel);
    }

    public static String convertAsJson(WDSIndexItemProtos.Item.Builder currentItem) {
        return JsonFormat.printToString((Message)currentItem.build());
    }

    private void setPublicationValues(DNGFProtos.DNGFEntity entity, WDSIndexItemProtos.Item.Builder indexItem) {
        List relevantDate;
        String embargoEndDate;
        PublicationProtos.Publication p = entity.getPublication();
        PublicationProtos.Publication.Metadata p_metadata = p.getMetadata();
        indexItem.setType("publication");
        this.addSubject(indexItem, p_metadata.getSubjectList());
        this.addTitle(indexItem, p_metadata.getTitleList());
        this.addDex(indexItem, p_metadata.getDescriptionList());
        String dateOfAcceptance = p_metadata.getDateofacceptance().getValue();
        if (dateOfAcceptance != null) {
            this.addDate(indexItem, dateOfAcceptance, "date of acceptance");
        }
        if ((embargoEndDate = p_metadata.getEmbargoenddate().getValue()) != null) {
            this.addDate(indexItem, embargoEndDate, "embargo end date");
        }
        if ((relevantDate = p_metadata.getRelevantdateList()) != null) {
            relevantDate.forEach(it -> this.addDate(indexItem, it.getValue(), "relevant date"));
        }
        this.addAuthors(indexItem, p.getAuthorList());
        this.addContributors(indexItem, p_metadata.getContributorList());
        this.addProjectRels(indexItem, (List)p_metadata.getExtension(WdsPublicationProtos.WdsPublication.projects));
    }

    private void setDatasetValues(DNGFProtos.DNGFEntity entity, WDSIndexItemProtos.Item.Builder indexItem) {
        List geopoints;
        List contributorList;
        List authorList;
        DatasetProtos.Dataset ds = entity.getDataset();
        DatasetProtos.Dataset.Metadata ds_metadata = ds.getMetadata();
        indexItem.setType("dataset");
        List subjectList = ds_metadata.getSubjectList();
        this.addSubject(indexItem, subjectList);
        List titleList = ds_metadata.getTitleList();
        this.addTitle(indexItem, titleList);
        List descriptionList = ds_metadata.getDescriptionList();
        this.addDex(indexItem, descriptionList);
        String dateOfAcceptance = ds_metadata.getDateofacceptance().getValue();
        this.addDate(indexItem, dateOfAcceptance, "date of acceptance");
        String embargoEndDate = ds_metadata.getEmbargoenddate().getValue();
        this.addDate(indexItem, embargoEndDate, "embargo end date");
        List relevantDate = ds_metadata.getRelevantdateList();
        relevantDate.forEach(it -> this.addDate(indexItem, it.getValue(), "relevant date"));
        String value = ds_metadata.getSize().getValue();
        indexItem.setSize(value);
        if (ds_metadata.getFormatList() != null && ds_metadata.getFormatList().size() > 0) {
            indexItem.setFormat(ds_metadata.getFormat(0).getValue());
        }
        if (ds_metadata.getVersion() != null) {
            indexItem.setVersion(ds_metadata.getVersion().getValue());
        }
        if ((authorList = ds.getAuthorList()) != null) {
            this.addAuthors(indexItem, authorList);
        }
        if ((contributorList = ds_metadata.getContributorList()) != null) {
            this.addContributors(indexItem, contributorList);
        }
        if ((geopoints = (List)ds_metadata.getExtension(WdsDatasetProtos.WdsDataset.geolocation)) != null) {
            geopoints.forEach(it -> this.addGeolocation(indexItem, (WdsDatasetProtos.WdsDataset.GeoLocation)it));
        }
        this.addRelations(indexItem, (List)ds_metadata.getExtension(WdsDatasetProtos.WdsDataset.otherRels));
        this.addProjectRels(indexItem, (List)ds_metadata.getExtension(WdsDatasetProtos.WdsDataset.projects));
    }

    public boolean isValid(DNGFProtos.DNGF mainEntity) {
        return mainEntity != null;
    }

    private void addIdentifier(WDSIndexItemProtos.Item.Builder indexItem, List<FieldTypeProtos.StructuredProperty> pidList) {
        pidList.forEach(it -> indexItem.addOriginalIdentifier(WDSIndexItemProtos.Identifier.newBuilder().setId(it.getValue()).setType(it.getQualifier().getClassid()).build()));
    }

    private void addSubject(WDSIndexItemProtos.Item.Builder indexItem, List<FieldTypeProtos.StructuredProperty> subjectList) {
        if (subjectList != null) {
            subjectList.forEach(it -> indexItem.addSubjects(WDSIndexItemProtos.SubjectType.newBuilder().setValue(it.getValue()).setScheme(it.getQualifier().getClassid()).build()));
        }
    }

    private void addTitle(WDSIndexItemProtos.Item.Builder indexItem, List<FieldTypeProtos.StructuredProperty> titleList) {
        if (titleList != null) {
            titleList.forEach(it -> {
                if (StringUtils.isNotBlank((CharSequence)it.getValue())) {
                    indexItem.addTitle(it.getValue());
                }
            });
        }
    }

    private void addDex(WDSIndexItemProtos.Item.Builder indexItem, List<FieldTypeProtos.StringField> dexList) {
        if (dexList != null) {
            dexList.forEach(it -> {
                if (StringUtils.isNotBlank((CharSequence)it.getValue())) {
                    indexItem.addDescription(it.getValue());
                }
            });
        }
    }

    private void addDate(WDSIndexItemProtos.Item.Builder indexItem, String date, String date_type) {
        if (StringUtils.isNotBlank((CharSequence)date)) {
            indexItem.addDate(WDSIndexItemProtos.DateType.newBuilder().setDate(date).setType(date_type).build());
        }
    }

    private void addProjectRels(WDSIndexItemProtos.Item.Builder indexItem, List<FieldTypeProtos.ProjectRelation> prjRels) {
        prjRels.forEach(it -> {
            if (prjRels != null) {
                indexItem.addProjects(FieldTypeProtos.ProjectRelation.newBuilder().setGrantId(it.getGrantId()).setFunder(it.getFunder()).setFundingStream(it.getFundingStream()).setAcronym(it.getAcronym()).setName(it.getName()).build());
            }
        });
    }

    private void addRelations(WDSIndexItemProtos.Item.Builder indexItem, List<WdsDatasetProtos.otherRelation> rels) {
        rels.forEach(it -> indexItem.addRelations(WDSIndexItemProtos.RelationType.newBuilder().setSemantic(it.getRelationSemantic()).setId(WDSIndexItemProtos.Identifier.newBuilder().setId(it.getTarget().getId()).setType(it.getTarget().getType()).build()).build()));
    }

    private void addGeolocation(WDSIndexItemProtos.Item.Builder indexItem, WdsDatasetProtos.WdsDataset.GeoLocation g) {
        WDSIndexItemProtos.GeoLocation.Builder glb = WDSIndexItemProtos.GeoLocation.newBuilder();
        if (g.hasPoint()) {
            glb.setPoint(g.getPoint());
        }
        if (g.hasPlace()) {
            glb.setPoint(g.getPlace());
        }
        if (g.getBoxCount() > 0) {
            for (int i = 0; i < g.getBoxCount(); ++i) {
                glb.addBox(g.getBox(i));
            }
        }
        indexItem.addGeolocation(glb.build());
    }

    private void addContributors(WDSIndexItemProtos.Item.Builder indexItem, List<FieldTypeProtos.StringField> contributors) {
        contributors.forEach(it -> indexItem.addContributor(this.addContributor("contributor", it.getValue())));
    }

    private void addAuthors(WDSIndexItemProtos.Item.Builder indexItem, List<PersonProtos.Person> authors) {
        authors.forEach(it -> indexItem.addContributor(this.addContributor("author", it.getMetadata().getFullname().getValue())));
    }

    private WDSIndexItemProtos.ContributorType addContributor(String type, String value) {
        return WDSIndexItemProtos.ContributorType.newBuilder().setType(type).setValue(value).build();
    }
}

