package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import eu.dnetlib.data.proto.*;
import eu.dnetlib.data.proto.WdsPublicationProtos;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.List;
import java.util.stream.Collectors;

public class WDSPmfToHbaseXsltFunctions extends OafToHbaseXsltFunctions {


    public static String pmfPublication(
            final String resultId,
            final String provenance,
            final String trust,
            final NodeList about,
            final String originalId,
            final String dateOfCollection,
            final String dateOfTransformation,
            final NodeList metadataNodes) {
        try {
            final ValueMap values = ValueMap.parseNodeList(metadataNodes);
            final Descriptors.Descriptor mDesc = PublicationProtos.Publication.Metadata.getDescriptor();
            final DNGFProtos.DNGFEntity.Builder entity = DNGFProtos.DNGFEntity.newBuilder();


            List<FieldTypeProtos.KeyValue.Builder> collectedFrom = WDSXSLTUtils.getDatasourceProvenance(about, "collectedFrom");

            List<FieldTypeProtos.KeyValue> cf = entity.getCollectedfromList();
            if (cf!= null)
            {
                List<FieldTypeProtos.KeyValue> ct = cf.stream().filter(it -> StringUtils.isNotBlank(it.getValue())).collect(Collectors.toList());
                if (ct== null || ct.size() == 0)
                    while (entity.getCollectedfromCount()>0)
                        entity.removeCollectedfrom(0);
            }
            if (collectedFrom!= null) {
                collectedFrom.forEach(entity::addCollectedfrom);
            }
            
            final PublicationProtos.Publication.Metadata.Builder metadata = buildMetadata(values, mDesc);
            addField(metadata, mDesc.findFieldByName("dateofacceptance"), values.get("date").listValues());
            final PublicationProtos.Publication.Builder publication = buildPublication(metadata, values, mDesc, "", "");
            parseProject(publication.getMetadataBuilder(), metadataNodes);
            final List<FieldTypeProtos.StructuredProperty> pids = Lists.newArrayList();
            pids.addAll(parsePids(metadataNodes));
            entity.setType(TypeProtos.Type.publication).setId(resultId);
            entity.setDateoftransformation(StringUtils.isBlank(dateOfTransformation) ? "" : dateOfTransformation);
            entity.setDateofcollection(StringUtils.isBlank(dateOfCollection) ? "" : dateOfCollection);
            entity.addAllPid(pids);
            entity.setDateofcollection(dateOfCollection)
                    .setDateoftransformation(dateOfTransformation).setOaiprovenance(getOAIProvenance(about));
            entity.setPublication(publication);

            final DNGFProtos.DNGF oaf = getOaf(entity, getDataInfo(about, provenance, trust, false, false));
            return base64(oaf.toByteArray());
        } catch (final Throwable e) {
            System.err.println(ExceptionUtils.getStackTrace(e));
            throw new IllegalArgumentException(e);
        }
    }

    private static  void parseProject(final PublicationProtos.Publication.Metadata.Builder metadata, final  NodeList metadataNodes ) {
        for (int i = 0; i < metadataNodes.getLength(); i++) {
            final Node node = metadataNodes.item(i);
            String acronym = null;
            String funder = null;
            String fundingStream = null;
            String grantId = null;
            String name = null;
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                if (node.getLocalName().equalsIgnoreCase("project")) {
                    acronym = node.getAttributes().getNamedItem("acronym").getTextContent();
                    funder = node.getAttributes().getNamedItem("funder").getTextContent();
                    fundingStream = node.getAttributes().getNamedItem("fundingStream").getTextContent();
                    grantId = node.getAttributes().getNamedItem("grantId").getTextContent();
                    name = node.getTextContent();
                    metadata.addExtension(WdsPublicationProtos.WdsPublication.projects,
                            FieldTypeProtos.ProjectRelation.newBuilder()
                                    .setAcronym(acronym)
                                    .setFunder(funder)
                                    .setFundingStream(fundingStream)
                                    .setGrantId(grantId)
                                    .setName(name)
                            .build());




                }

            }
        }

    }


    protected static List<FieldTypeProtos.StructuredProperty> parsePids(final NodeList nodelist) {

        final List<FieldTypeProtos.StructuredProperty> pids = Lists.newArrayList();

        for (int i = 0; i < nodelist.getLength(); i++) {
            final Node node = nodelist.item(i);
            String pidType = null;
            String pidValue = null;
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                if (node.getLocalName().equalsIgnoreCase("pid")) {
                    pidType = node.getAttributes().getNamedItem("type").getTextContent();
                    pidValue = node.getTextContent();
                    if (StringUtils.isNotEmpty(pidType) && StringUtils.isNotEmpty(pidValue))
                    {
                        pids.add(getStructuredProperty(pidValue, pidType, pidType, "dnet:pid_types", "dnet:pid_types"));
                    }
                }
                //this is to handle dataset pids
            }
        }
        return pids;
    }
}
