/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WdsPublicationProtos;
import eu.dnetlib.data.transform.xml.OafToHbaseXsltFunctions;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.data.transform.xml.WDSXSLTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WDSPmfToHbaseXsltFunctions
extends OafToHbaseXsltFunctions {
    public static String pmfPublication(String resultId, String provenance, String trust, NodeList about, String originalId, String dateOfCollection, String dateOfTransformation, NodeList metadataNodes) {
        try {
            List ct;
            ValueMap values = ValueMap.parseNodeList((NodeList)metadataNodes);
            Descriptors.Descriptor mDesc = PublicationProtos.Publication.Metadata.getDescriptor();
            DNGFProtos.DNGFEntity.Builder entity = DNGFProtos.DNGFEntity.newBuilder();
            List<FieldTypeProtos.KeyValue.Builder> collectedFrom = WDSXSLTUtils.getDatasourceProvenance(about, "collectedFrom");
            List cf = entity.getCollectedfromList();
            if (cf != null && ((ct = cf.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getValue())).collect(Collectors.toList())) == null || ct.size() == 0)) {
                while (entity.getCollectedfromCount() > 0) {
                    entity.removeCollectedfrom(0);
                }
            }
            if (collectedFrom != null) {
                collectedFrom.forEach(arg_0 -> ((DNGFProtos.DNGFEntity.Builder)entity).addCollectedfrom(arg_0));
            }
            PublicationProtos.Publication.Metadata.Builder metadata = WDSPmfToHbaseXsltFunctions.buildMetadata((ValueMap)values, (Descriptors.Descriptor)mDesc);
            WDSPmfToHbaseXsltFunctions.addField((Message.Builder)metadata, (Descriptors.FieldDescriptor)mDesc.findFieldByName("dateofacceptance"), (Object)values.get((Object)"date").listValues());
            PublicationProtos.Publication.Builder publication = WDSPmfToHbaseXsltFunctions.buildPublication((PublicationProtos.Publication.Metadata.Builder)metadata, (ValueMap)values, (Descriptors.Descriptor)mDesc, (String)"", (String)"");
            WDSPmfToHbaseXsltFunctions.parseProject(publication.getMetadataBuilder(), metadataNodes);
            ArrayList pids = Lists.newArrayList();
            pids.addAll(WDSPmfToHbaseXsltFunctions.parsePids(metadataNodes));
            entity.setType(TypeProtos.Type.publication).setId(resultId);
            entity.setDateoftransformation(StringUtils.isBlank((CharSequence)dateOfTransformation) ? "" : dateOfTransformation);
            entity.setDateofcollection(StringUtils.isBlank((CharSequence)dateOfCollection) ? "" : dateOfCollection);
            entity.addAllPid((Iterable)pids);
            entity.setDateofcollection(dateOfCollection).setDateoftransformation(dateOfTransformation).setOaiprovenance(WDSPmfToHbaseXsltFunctions.getOAIProvenance((NodeList)about));
            entity.setPublication(publication);
            DNGFProtos.DNGF oaf = WDSPmfToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFEntity.Builder)entity, (FieldTypeProtos.DataInfo.Builder)WDSPmfToHbaseXsltFunctions.getDataInfo((NodeList)about, (String)provenance, (String)trust, (boolean)false, (boolean)false));
            return WDSPmfToHbaseXsltFunctions.base64((byte[])oaf.toByteArray());
        }
        catch (Throwable e) {
            System.err.println(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IllegalArgumentException(e);
        }
    }

    private static void parseProject(PublicationProtos.Publication.Metadata.Builder metadata, NodeList metadataNodes) {
        for (int i = 0; i < metadataNodes.getLength(); ++i) {
            Node node = metadataNodes.item(i);
            String acronym = null;
            String funder = null;
            String fundingStream = null;
            String grantId = null;
            String name = null;
            if (node.getNodeType() != 1 || !node.getLocalName().equalsIgnoreCase("project")) continue;
            acronym = node.getAttributes().getNamedItem("acronym").getTextContent();
            funder = node.getAttributes().getNamedItem("funder").getTextContent();
            fundingStream = node.getAttributes().getNamedItem("fundingStream").getTextContent();
            grantId = node.getAttributes().getNamedItem("grantId").getTextContent();
            name = node.getTextContent();
            metadata.addExtension(WdsPublicationProtos.WdsPublication.projects, (Object)FieldTypeProtos.ProjectRelation.newBuilder().setAcronym(acronym).setFunder(funder).setFundingStream(fundingStream).setGrantId(grantId).setName(name).build());
        }
    }

    protected static List<FieldTypeProtos.StructuredProperty> parsePids(NodeList nodelist) {
        ArrayList pids = Lists.newArrayList();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            String pidType = null;
            String pidValue = null;
            if (node.getNodeType() != 1 || !node.getLocalName().equalsIgnoreCase("pid")) continue;
            pidType = node.getAttributes().getNamedItem("type").getTextContent();
            pidValue = node.getTextContent();
            if (!StringUtils.isNotEmpty((CharSequence)pidType) || !StringUtils.isNotEmpty((CharSequence)pidValue)) continue;
            pids.add(WDSPmfToHbaseXsltFunctions.getStructuredProperty((String)pidValue, (String)pidType, (String)pidType, (String)"dnet:pid_types", (String)"dnet:pid_types"));
        }
        return pids;
    }
}

