/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import eu.dnetlib.data.transform.xml.OdfToHbaseXsltFunctions;
import eu.dnetlib.data.transform.xml.RelatedIdentifier;
import eu.dnetlib.data.transform.xml.WDSXSLTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WdsToHbaseXsltFunctions
extends OdfToHbaseXsltFunctions {
    public static String wdsDataset(String resultId, NodeList about, NodeList titles, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList dateaccepted, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList cobjcategory, NodeList contributors, NodeList rights, NodeList version, NodeList pidList, NodeList geoLocations, String provenance, String trust, String hostedbyId, String hostedbyName, String collectedfromId, String collectedfromName, NodeList originalIds, String instanceUri, String dateOfCollection, String dateOfTransformation, NodeList relatedIdentifiers) {
        try {
            List<FieldTypeProtos.KeyValue.Builder> collectedFrom;
            List ct;
            DNGFProtos.DNGFEntity.Builder entity = WdsToHbaseXsltFunctions.odfDatasetProto((String)resultId, (NodeList)about, (NodeList)titles, (NodeList)subjects, (NodeList)publisher, (NodeList)descriptions, (NodeList)dates, (NodeList)dateaccepted, (NodeList)resourceTypes, (NodeList)formats, (NodeList)sizes, (NodeList)languages, (NodeList)cobjcategory, (NodeList)contributors, (NodeList)rights, (NodeList)version, (NodeList)pidList, (String)hostedbyId, (String)hostedbyName, (String)collectedfromId, (String)collectedfromName, (NodeList)originalIds, (String)instanceUri, (String)dateOfCollection, (String)dateOfTransformation);
            List cf = entity.getCollectedfromList();
            if (cf != null && ((ct = cf.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getValue())).collect(Collectors.toList())) == null || ct.size() == 0)) {
                while (entity.getCollectedfromCount() > 0) {
                    entity.removeCollectedfrom(0);
                }
            }
            if ((collectedFrom = WDSXSLTUtils.getDatasourceProvenance(about, "collectedFrom")) != null) {
                collectedFrom.forEach(it -> {
                    if (StringUtils.isNotEmpty((CharSequence)it.getValue())) {
                        entity.addCollectedfrom(it);
                    }
                });
            }
            List<RelatedIdentifier> parsedRelatedIdentifiers = WdsToHbaseXsltFunctions.parseRelatedIdentifiers(relatedIdentifiers);
            parsedRelatedIdentifiers.stream().filter(it -> !it.getTargetIdType().equals("dnet")).forEach(r -> {
                DatasetProtos.Dataset.Metadata.Builder cfr_ignored_0 = (DatasetProtos.Dataset.Metadata.Builder)entity.getDatasetBuilder().getMetadataBuilder().addExtension(WdsDatasetProtos.WdsDataset.otherRels, (Object)r.toOtherRelation());
            });
            if (geoLocations != null) {
                WdsToHbaseXsltFunctions.parseGeoLocations(entity, geoLocations);
            }
            DNGFProtos.DNGF dngf = WdsToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFEntity.Builder)entity, (FieldTypeProtos.DataInfo.Builder)WdsToHbaseXsltFunctions.getDataInfo((NodeList)about, (String)provenance, (String)trust, (boolean)false, (boolean)false));
            return WdsToHbaseXsltFunctions.base64((byte[])dngf.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private static void parseGeoLocations(DNGFProtos.DNGFEntity.Builder entity, NodeList geoLocations) {
        ArrayList geos = Lists.newArrayList();
        for (int i = 0; i < geoLocations.getLength(); ++i) {
            Node geo = geoLocations.item(i);
            NodeList getlist = geo.getChildNodes();
            for (int j = 0; j < getlist.getLength(); ++j) {
                Node geoLocation = getlist.item(j);
                NodeList geoChildren = geoLocation.getChildNodes();
                WdsDatasetProtos.WdsDataset.GeoLocation.Builder g2 = WdsDatasetProtos.WdsDataset.GeoLocation.newBuilder();
                block12: for (int k = 0; k < geoChildren.getLength(); ++k) {
                    Node geoChild = geoChildren.item(k);
                    String value = geoChild.getTextContent();
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    switch (geoChild.getNodeName()) {
                        case "geoLocationPoint": {
                            String point = value.trim();
                            g2.setPoint(point);
                            continue block12;
                        }
                        case "geoLocationBox": {
                            String box = value.trim();
                            g2.addBox(box);
                            continue block12;
                        }
                        case "geoLocationPlace": {
                            g2.setPlace(value.trim());
                            continue block12;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid element: " + geoChild.getNodeName());
                        }
                    }
                }
                if (!g2.hasPlace() && !g2.hasPoint() && g2.getBoxCount() <= 0) continue;
                geos.add(g2.build());
            }
        }
        geos.forEach(g -> {
            DatasetProtos.Dataset.Metadata.Builder cfr_ignored_0 = (DatasetProtos.Dataset.Metadata.Builder)entity.getDatasetBuilder().getMetadataBuilder().addExtension(WdsDatasetProtos.WdsDataset.geolocation, g);
        });
    }

    public static String createRel(String source, String target, String relationSemantic, String relType, String provenanceAction, String trust, NodeList about) {
        try {
            DNGFProtos.DNGFRel.Builder rel = WdsToHbaseXsltFunctions.relProto((String)source.trim(), (String)target.trim(), (String)relationSemantic, (String)relType);
            DNGFProtos.DNGF pmf = WdsToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFRel.Builder)rel, (FieldTypeProtos.DataInfo.Builder)WdsToHbaseXsltFunctions.getDataInfo((NodeList)about, (String)provenanceAction, (String)trust, (boolean)false, (boolean)false));
            return WdsToHbaseXsltFunctions.base64((byte[])pmf.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private static List<RelatedIdentifier> parseRelatedIdentifiers(NodeList relatedIdentifier) {
        ArrayList<RelatedIdentifier> result = new ArrayList<RelatedIdentifier>();
        for (int i = 0; i < relatedIdentifier.getLength(); ++i) {
            Node currentNode = relatedIdentifier.item(i);
            String targetId = currentNode.getTextContent();
            NamedNodeMap attributes = currentNode.getAttributes();
            String entityType = WdsToHbaseXsltFunctions.getAttributeValue((NamedNodeMap)attributes, (String)"entityType");
            String relatedIdentifierType = WdsToHbaseXsltFunctions.getAttributeValue((NamedNodeMap)attributes, (String)"relatedIdentifierType");
            String relationType = WdsToHbaseXsltFunctions.getAttributeValue((NamedNodeMap)attributes, (String)"relationType");
            result.add(new RelatedIdentifier(entityType, targetId, relationType, relatedIdentifierType));
        }
        return result;
    }
}

