package eu.dnetlib.data.transform.xml;

import eu.dnetlib.data.proto.FieldTypeProtos;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.ArrayList;
import java.util.List;

public class WDSXSLTUtils {

    public static List<FieldTypeProtos.KeyValue.Builder> getDatasourceProvenance(NodeList about, final String nodeName) {
        Node dataInfoNode = AbstractDNetXsltFunctions.getDataInfo(about);
        if (dataInfoNode != null && dataInfoNode.getChildNodes() != null && dataInfoNode.getChildNodes().getLength() > 0) {
            List<FieldTypeProtos.KeyValue.Builder> result = new ArrayList<>();

            for (int i = 0; i < dataInfoNode.getChildNodes().getLength(); i++) {
                final Node currentNode = dataInfoNode.getChildNodes().item(i);
                if (nodeName.equals(currentNode.getLocalName())) {
                    FieldTypeProtos.KeyValue.Builder currentItem = FieldTypeProtos.KeyValue.newBuilder();
                    final Node idNode = currentNode.getAttributes().getNamedItem("id");
                    final Node nameNode = currentNode.getAttributes().getNamedItem("name");

                    if (idNode != null) {
                        currentItem.setKey(idNode.getTextContent());
                    }
                    if (nameNode != null) {
                        currentItem.setValue(nameNode.getTextContent());
                    }

                    result.add(currentItem);
                }
            }
            return result;
        }
        return null;
    }


}
