package eu.dnetlib.data.transform.xml;

import org.apache.commons.lang3.StringUtils;

import static eu.dnetlib.data.proto.WdsDatasetProtos.*;


public class RelatedIdentifier {

    private String entityType ;
    private String targetId ;
    private String relationSemantic;
    private String targetIdType;

    public RelatedIdentifier() {
    }

    public RelatedIdentifier(String entityType, String targetId, String relationSemantic, String targetIdType) {
        this.entityType = entityType;
        this.targetId = targetId;
        this.relationSemantic = relationSemantic;
        this.targetIdType = targetIdType;
    }

    public String getEntityType() {
        return entityType;
    }

    public RelatedIdentifier setEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    public String getTargetId() {
        return targetId;
    }

    public RelatedIdentifier setTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public String getRelationSemantic() {
        return relationSemantic;
    }

    public RelatedIdentifier setRelationSemantic(String relationSemantic) {
        this.relationSemantic = relationSemantic;
        return this;
    }

    public String getTargetIdType() {
        return targetIdType;
    }

    public RelatedIdentifier setTargetIdType(String targetIdType) {
        this.targetIdType = targetIdType;
        return this;
    }


    public otherRelation toOtherRelation () {
        final otherRelation.Builder builder = otherRelation.newBuilder();
        builder.setRelationSemantic(relationSemantic);
        builder.setTarget(otherRelationIdentifier.newBuilder().setId(targetId).setType(targetIdType).build());
        if (StringUtils.isNotEmpty(entityType)) {
            builder.setTargetType(entityType);
        }
        return builder.build();
    }
}
