package eu.dnetlib.data.transform.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DNGFProtos.DNGF;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity.Builder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos.WdsDataset;
import eu.dnetlib.data.proto.WdsDatasetProtos.WdsDataset.GeoLocation;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Created by claudio on 30/08/16.
 */
public class WdsToHbaseXsltFunctions extends OdfToHbaseXsltFunctions {

	public static String wdsDataset(
			final String resultId,
			final NodeList about,
			final NodeList titles,
			final NodeList subjects,
			final NodeList publisher,
			final NodeList descriptions,
			final NodeList dates,
			final NodeList dateaccepted,
			final NodeList resourceTypes,
			final NodeList formats,
			final NodeList sizes,
			final NodeList languages,
			final NodeList cobjcategory,
			final NodeList contributors,
			final NodeList rights,
			final NodeList version,
			final NodeList pidList,
			final NodeList geoLocations,
			final String provenance,
			final String trust,
			final String hostedbyId,
			final String hostedbyName,
			final String collectedfromId,
			final String collectedfromName,
			final NodeList originalIds,
			final String instanceUri,
			final String dateOfCollection,
			final String dateOfTransformation,
			final NodeList relatedIdentifiers
			) {

		try {
			final DNGFEntity.Builder entity = odfDatasetProto(
					resultId, about, titles, subjects, publisher, descriptions, dates, dateaccepted,
					resourceTypes, formats, sizes, languages, cobjcategory, contributors, rights, version,
					pidList, hostedbyId, hostedbyName, collectedfromId, collectedfromName,
					originalIds, instanceUri, dateOfCollection, dateOfTransformation);

			List<FieldTypeProtos.KeyValue> cf = entity.getCollectedfromList();
			if (cf!= null)
			{
				List<FieldTypeProtos.KeyValue> ct = cf.stream().filter(it -> StringUtils.isNotBlank(it.getValue())).collect(Collectors.toList());
				if (ct== null || ct.size() == 0)
					while (entity.getCollectedfromCount()>0)
						entity.removeCollectedfrom(0);
			}

			List<FieldTypeProtos.KeyValue.Builder> collectedFrom = WDSXSLTUtils.getDatasourceProvenance(about, "collectedFrom");
			if (collectedFrom!= null) {
				collectedFrom.forEach(it -> {
					if (StringUtils.isNotEmpty(it.getValue())){
						entity.addCollectedfrom(it);
					}
				});
			}
			List<RelatedIdentifier> parsedRelatedIdentifiers = parseRelatedIdentifiers(relatedIdentifiers);
			parsedRelatedIdentifiers.stream().filter(it -> !it.getTargetIdType().equals("dnet")).forEach(
					r -> entity.getDatasetBuilder().getMetadataBuilder().addExtension(WdsDataset.otherRels, r.toOtherRelation()));

			if(geoLocations != null) {
				parseGeoLocations(entity, geoLocations);
			}

			final DNGF dngf = getOaf(entity, getDataInfo(about, provenance, trust, false, false));




			return base64(dngf.toByteArray());
		} catch (Throwable e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}





	private static void parseGeoLocations(final Builder entity, final NodeList geoLocations) {
		final List<GeoLocation> geos = Lists.newArrayList();
		for (int i = 0; i < geoLocations.getLength(); i++) {
			final Node geo = geoLocations.item(i);
			final NodeList getlist = geo.getChildNodes();

			for (int j = 0; j < getlist.getLength(); j++) {
				final Node geoLocation = getlist.item(j);
				final NodeList geoChildren = geoLocation.getChildNodes();

				final GeoLocation.Builder g = GeoLocation.newBuilder();
				for (int k = 0; k < geoChildren.getLength(); k++) {
					final Node geoChild = geoChildren.item(k);

					final String value = geoChild.getTextContent();
					if (StringUtils.isNotBlank(value)) {
						switch (geoChild.getNodeName()) {
						case "geoLocationPoint":
							final String point = value.trim();
							g.setPoint(point);
							break;
						case "geoLocationBox":
							final String box = value.trim();
							g.addBox(box);
							break;
						case "geoLocationPlace":
							g.setPlace(value.trim());
							break;
						default:
							throw new IllegalArgumentException("invalid element: " + geoChild.getNodeName());
						}
					}
				}
				if(g.hasPlace() || g.hasPoint() || g.getBoxCount() > 0) {
					geos.add(g.build());
				}
			}
		}

		geos.forEach(g -> entity.getDatasetBuilder().getMetadataBuilder().addExtension(WdsDataset.geolocation, g));
	}

	public static String createRel(
			final String source,
			final String target,
			final String relationSemantic,
			final String relType,
			final String provenanceAction,
			final String trust,
			final NodeList about) {

		try {
			DNGFProtos.DNGFRel.Builder rel = relProto(source.trim(), target.trim(), relationSemantic, relType);
			final DNGFProtos.DNGF pmf = getOaf(rel, getDataInfo(about, provenanceAction, trust, false, false));
			return base64(pmf.toByteArray());
		} catch (Throwable e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}

	}


	private static List<RelatedIdentifier>  parseRelatedIdentifiers(final NodeList relatedIdentifier) {
		List<RelatedIdentifier> result = new ArrayList<>();
		for(int i =0; i < relatedIdentifier.getLength(); i++ ) {
			final Node currentNode = relatedIdentifier.item(i);
			final String targetId =currentNode.getTextContent();
			final NamedNodeMap attributes = currentNode.getAttributes();
			final String entityType  = getAttributeValue(attributes, "entityType");
			final String relatedIdentifierType  = getAttributeValue(attributes, "relatedIdentifierType");
			final String relationType  = getAttributeValue(attributes, "relationType");
			result.add(new RelatedIdentifier(entityType, targetId, relationType, relatedIdentifierType));
		}
		return result;

	}






}
