/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.utils;

import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.data.transform.OntologyTerm;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WDSUtils {
    public static Ontologies ontologies;
    public static final Map<String, Pair<String, String>> hostedByMap;
    public static final Map<String, Pair<String, String>> collectedFromMap;
    public static String HOSTED_BY_MAP_QUERY;
    public static String COLLECTEDFROM_DATASOURCE_MAP_QUERY;
    private static WDSUtils instance;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public static String getInverse(String relation) throws Exception {
        if (ontologies == null) {
            ontologies = OntologyLoader.loadOntologiesFromIS();
        }
        String normalizedRelation = WDSUtils.normalizeRelation(relation);
        try {
            return ((OntologyTerm)ontologies.getTerms(normalizedRelation).stream().findFirst().get()).getInverseCode();
        }
        catch (Throwable e) {
            System.out.println("Relation not found = " + normalizedRelation);
            return "related";
        }
    }

    public static String normalizeRelation(String relation) {
        if (relation == null || StringUtils.isEmpty((CharSequence)relation)) {
            return null;
        }
        return Character.toLowerCase(relation.charAt(0)) + relation.substring(1);
    }

    public static void generateDSMapFromQuery(Map<String, Pair<String, String>> aMap, String aQUERY) throws Exception {
        ISLookUpService lookUpService = (ISLookUpService)instance.getServiceLocator().getService(ISLookUpService.class);
        List hostedByList = lookUpService.quickSearchProfile(aQUERY);
        aMap.clear();
        aMap.putAll(hostedByList.stream().map(s -> s.split("<-->")).map(s -> new Pair((Object)StringEscapeUtils.escapeXml11((String)s[1]), (Object)new Pair((Object)s[0], (Object)s[2]))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    public static String getNameFromDataSourcePrefix(String datasourcePrefix) throws Exception {
        if (collectedFromMap.keySet().size() == 0) {
            WDSUtils.generateDSMapFromQuery(collectedFromMap, COLLECTEDFROM_DATASOURCE_MAP_QUERY);
        }
        if (!collectedFromMap.containsKey(datasourcePrefix)) {
            return "";
        }
        return (String)collectedFromMap.get(datasourcePrefix).getValue();
    }

    public static String getIdFromDataSourcePrefix(String datasourcePrefix) throws Exception {
        if (collectedFromMap.keySet().size() == 0) {
            WDSUtils.generateDSMapFromQuery(collectedFromMap, COLLECTEDFROM_DATASOURCE_MAP_QUERY);
        }
        if (!collectedFromMap.containsKey(datasourcePrefix)) {
            return "";
        }
        return (String)collectedFromMap.get(datasourcePrefix).getKey();
    }

    public static String getDatasourceName(String dataCenter) throws Exception {
        Pair<String, String> result;
        if (hostedByMap.keySet().isEmpty()) {
            WDSUtils.generateDSMapFromQuery(hostedByMap, HOSTED_BY_MAP_QUERY);
        }
        return (result = hostedByMap.get(dataCenter)) == null ? null : (String)result.getValue();
    }

    public static String getDatasourceId(String dataCenter) throws Exception {
        Pair<String, String> result;
        if (hostedByMap.keySet().isEmpty()) {
            WDSUtils.generateDSMapFromQuery(hostedByMap, HOSTED_BY_MAP_QUERY);
        }
        return (result = hostedByMap.get(dataCenter)) == null ? null : (String)result.getKey();
    }

    public static String generateWDSNsPrefix(String input, String prefix, int maxLength) {
        if (StringUtils.isNotEmpty((CharSequence)input) && StringUtils.isNotEmpty((CharSequence)prefix)) {
            String cleanedString = input.replace("/", "_");
            int remainingLength = maxLength - prefix.length();
            cleanedString = cleanedString.length() > remainingLength ? cleanedString.substring(0, remainingLength) : StringUtils.rightPad((String)cleanedString, (int)remainingLength, (String)"_");
            return prefix + cleanedString;
        }
        return null;
    }

    public static String getDOI(String pid) {
        Pattern pattern = Pattern.compile("10\\.\\d{4,9}/[-._;()/:A-Z0-9]+$", 2);
        Matcher matcher = pattern.matcher(pid);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    public static boolean isDate(String date) {
        Pattern pattern = Pattern.compile("\\d{4}");
        Matcher matcher = pattern.matcher(date);
        return matcher.find();
    }

    public static void setInstance(WDSUtils mockInstance) {
        instance = mockInstance;
    }

    @PostConstruct
    public void registerInstance() throws Exception {
        instance = this;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public static String generateIdentifier(String pid, String pidtype) {
        if (StringUtils.isBlank((CharSequence)pid) || StringUtils.isBlank((CharSequence)pidtype)) {
            throw new RuntimeException("Error pid or pidtype cannot be null");
        }
        return DnetXsltFunctions.md5((String)String.format("%s::%s", pid.toLowerCase().trim(), pidtype.toLowerCase().trim()));
    }

    static {
        hostedByMap = new HashMap<String, Pair<String, String>>();
        collectedFromMap = new HashMap<String, Pair<String, String>>();
        HOSTED_BY_MAP_QUERY = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') where $x//FIELD/key/text()= 'archive_center'  return concat($x//DATASOURCE_ORIGINAL_ID, '<-->', $x//FIELD[./key/text()= 'archive_center' ]/value/string(), '<-->', $x//OFFICIAL_NAME)";
        COLLECTEDFROM_DATASOURCE_MAP_QUERY = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')  where $x//FIELD/key/text()!= 'archive_center'  return  concat($x//DATASOURCE_ORIGINAL_ID, '<-->', $x//FIELD[./key/text()= 'NamespacePrefix' ]/value/string(), '<-->', $x//OFFICIAL_NAME)";
    }
}

