/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.collector.plugins;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.dnetlib.wds.collector.plugins.CMRObject;
import eu.dnetlib.wds.collector.plugins.CMRObjectDeserializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMRIterator
implements Iterator<CMRObject> {
    private static final String BASE_URL_PAGE = "https://cmr.earthdata.nasa.gov/search/collections.json?pretty=true&page_size=50&page_num=%d";
    private static final Log log = LogFactory.getLog(CMRIterator.class);
    private int current_page = 1;
    private CMRObject nextElement = null;
    private List<CMRObject> buffer = new ArrayList<CMRObject>();
    private Gson gson = null;

    public CMRIterator() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CMRObject.class, (Object)new CMRObjectDeserializer());
        this.gson = builder.create();
        this.calculateNextElement();
    }

    private void calculateNextElement() {
        try {
            URL myURL = new URL(String.format(BASE_URL_PAGE, this.current_page));
            String result = IOUtils.toString((InputStream)myURL.openStream());
            JsonElement element = new JsonParser().parse(result);
            JsonArray asJsonArray = element.getAsJsonObject().get("feed").getAsJsonObject().get("entry").getAsJsonArray();
            if (asJsonArray.size() > 0) {
                for (JsonElement el : asJsonArray) {
                    CMRObject resultObj = (CMRObject)this.gson.fromJson(el.toString(), CMRObject.class);
                    this.buffer.add(resultObj);
                }
                ++this.current_page;
                return;
            }
        }
        catch (Throwable e) {
            log.error((Object)String.format("Error on calculate next Element, The iterator will be shut down", new Object[0]), e);
        }
        this.nextElement = null;
    }

    @Override
    public boolean hasNext() {
        return this.buffer.size() > 0;
    }

    @Override
    public CMRObject next() {
        CMRObject temp = this.buffer.remove(0);
        if (this.buffer.size() < 10) {
            this.calculateNextElement();
        }
        return temp;
    }
}

