package eu.dnetlib.resolver.mdstore.plugin;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.RecordResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.RecordResolverFactory;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;

import java.util.List;
import java.util.concurrent.BlockingQueue;

public class WDSRecordResolverFactory implements RecordResolverFactory {
    @Override
    public RecordResolver createResolver(BlockingQueue<DBObject> queue, MongoCollection<DBObject> outputCollection, ResolverSerializer serializer, List<PIDResolver> pluginResolver, final boolean offline) {

        return createResolver(System.currentTimeMillis(), queue, outputCollection, serializer, pluginResolver, offline);
    }

    @Override
    public RecordResolver createResolver(long identifier, BlockingQueue<DBObject> queue, MongoCollection<DBObject> outputCollection, ResolverSerializer serializer, List<PIDResolver> pluginResolver, boolean offline) {
        final WDSRecordResolver resolver = new WDSRecordResolver(System.currentTimeMillis());
        resolver.setInputQueue(queue);
        resolver.setOutputCollection(outputCollection);
        resolver.setSerializer(serializer);
        resolver.setPluginResolver(pluginResolver);
        resolver.setOffline(offline);
        return resolver;
    }
}
