<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:datacite="http://datacite.org/schema/kernel-3"
                xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
                xmlns:oai="http://www.openarchives.org/OAI/2.0/"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:dnet="eu.dnetlib.wds.utils.WDSUtils"
                xmlns:oaf="http://namespace.dnet.eu/oaf"
                exclude-result-prefixes="xsl datetime exslt dnet"
                version="2.0">

    <xsl:output method="xml" indent="yes"/>
    <xsl:variable name="namespacePrefix">
        <xsl:value-of select="string('wds_resolver')"/>
    </xsl:variable>
    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="//datacite:resource">
                <xsl:call-template name="dataset">
                    <xsl:with-param name="metadata">
                        <xsl:value-of select="//*[local-name()='metadata']"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="//oaf:pid">
                <xsl:call-template name="publication">
                    <xsl:with-param name="metadata">
                        <xsl:value-of select="//*[local-name()='metadata']"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <JUNK/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="dataset">
        <xsl:param name="metadata"/>
        <xsl:variable name="datestamp" select="datetime:dateTime()"/>
        <xsl:variable name="evaluatedId" select="normalize-space(//datacite:identifier/text())"/>
        <xsl:variable name="evaluatedIdType" select="normalize-space(//datacite:identifier/@identifierType)"/>
        <xsl:variable name="generatedIDataset" select="dnet:generateIdentifier($evaluatedId,  $evaluatedIdType)"/>

        <oai:record xmlns:oai="http://www.openarchives.org/OAI/2.0/"
                    xmlns:dri="http://www.driver-repository.eu/namespace/dri">
            <oai:header>
                <dri:objIdentifier>
                    <xsl:value-of select="concat($namespacePrefix,'::', $generatedIDataset)"/>
                </dri:objIdentifier>
                <dri:recordIdentifier>
                    <xsl:value-of select="$generatedIDataset"/>
                </dri:recordIdentifier>
                <dri:dateOfCollection>
                    <xsl:value-of select="$datestamp"/>
                </dri:dateOfCollection>
                <dri:repositoryId>
                    <xsl:value-of select="$namespacePrefix"/>
                </dri:repositoryId>
                <dri:datasourceprefix>
                    <xsl:value-of select="$namespacePrefix"/>
                </dri:datasourceprefix>
            </oai:header>
            <xsl:copy-of select=".//*[local-name()='metadata']"/>
            <xsl:copy-of select=".//oaf:about"/>

        </oai:record>
    </xsl:template>

    <xsl:template name="publication">
        <xsl:param name="metadata"/>
        <xsl:variable name="datestamp" select="datetime:dateTime()"/>
        <xsl:variable name="evaluatedId" select="normalize-space(//oaf:pid)"/>
        <xsl:variable name="evaluatedIdType" select="normalize-space(//oaf:pid/@type)"/>
        <xsl:variable name="generatedIDPublication" select="dnet:generateIdentifier($evaluatedId,  $evaluatedIdType)"/>

        <oai:record xmlns:oai="http://www.openarchives.org/OAI/2.0/"
                    xmlns:dri="http://www.driver-repository.eu/namespace/dri">
            <oai:header>
                <dri:objIdentifier>
                    <xsl:value-of select="concat($namespacePrefix,'::', $generatedIDPublication)"/>
                </dri:objIdentifier>
                <dri:recordIdentifier>
                    <xsl:value-of select="$generatedIDPublication"/>
                </dri:recordIdentifier>
                <dri:dateOfCollection>
                    <xsl:value-of select="$datestamp"/>
                </dri:dateOfCollection>
                <dri:repositoryId>
                    <xsl:value-of select="$namespacePrefix"/>
                </dri:repositoryId>
                <dri:datasourceprefix>
                    <xsl:value-of select="$namespacePrefix"/>
                </dri:datasourceprefix>
            </oai:header>
            <xsl:copy-of select=".//*[local-name()='metadata']"/>
            <xsl:copy-of select=".//oaf:about"/>
        </oai:record>
    </xsl:template>


</xsl:stylesheet>
