package eu.dnetlib.resolver.mdstore.plugin;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.AbstractRecordResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.wds.parser.WDSParser;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import eu.dnetlib.wds.resolver.serializers.WDSResolverSerializer;
import eu.dnetlib.wds.utils.WDSUtils;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public class WDSRecordResolver extends AbstractRecordResolver {


    private final WDSParser parser = new WDSParser();

    public WDSRecordResolver(long ts) {
        super(ts);
    }


    @Override
    public String resolve(final String inputRecord) {

        final WDSResolvedObject inputObject = (WDSResolvedObject) parser.parse(inputRecord);
        if (inputObject == null) {
            log.error("Error on parsing record the result is null, record: " + inputRecord);
            return null;
        }

        if (inputObject != null && !StringUtils.isBlank(inputObject.getPid())) {
            log.debug("trying to resolve " + inputObject.getPid());
        }

        boolean shouldUpdate = false;

        final String newXML = resolveRelations(inputRecord, inputObject, shouldUpdate);
        if (newXML != null) return newXML;
        return null;
    }

    protected Map<String, ObjectType> tryToResolveRelation(final PID currentPid) {
        if (currentPid.getId() != null && currentPid.getId().contains("wds_resolver")) {
            return null;
        }
        log.debug("tryToResolveRelation " + currentPid);

        for (PIDResolver resolver : pluginResolver) {
            final WDSResolvedObject currentIdentifier = (WDSResolvedObject) resolver.retrievePID(currentPid.getId(), currentPid.getType(),offline);


            if (currentIdentifier != null && !StringUtils.isBlank(currentIdentifier.getPid()) && currentIdentifier.getPid().toLowerCase().equals(currentPid.getId().toLowerCase())) {
                final HashMap<String, ObjectType> result = new HashMap<>();
                result.put("wds_resolver::" + WDSUtils.generateIdentifier(currentIdentifier.getPid(), currentIdentifier.getPidType()),
                        currentIdentifier.getType());
                return result;
            }
        }
        return null;
    }


    public void setPluginResolver(final List<PIDResolver> pluginResolver) {
        this.pluginResolver = pluginResolver;
    }


    public BlockingQueue<DBObject> getInputQueue() {
        return inputQueue;
    }

    public void setInputQueue(final BlockingQueue<DBObject> inputQueue) {
        this.inputQueue = inputQueue;
    }

    public MongoCollection<DBObject> getOutputCollection() {
        return outputCollection;
    }

    public void setOutputCollection(final MongoCollection<DBObject> outputCollection) {
        this.outputCollection = outputCollection;
    }

    public void setSerializer(final ResolverSerializer serializer) {
        final WDSResolverSerializer tmp = new WDSResolverSerializer();
        tmp.setPmfTemplate(new StringTemplate(((WDSResolverSerializer) serializer).getPmfTemplate().getTemplate()));
        tmp.setDmfTemplate(new StringTemplate(((WDSResolverSerializer) serializer).getDmfTemplate().getTemplate()));
        this.serializer = tmp;
    }
}
