/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.collector.plugins;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import eu.dnetlib.wds.collector.plugins.GenericDatasource;
import eu.dnetlib.wds.utils.WDSUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMRDatasourcePlugin
extends AbstractCollectorPlugin {
    private static final String BASE_URL = "https://cmr.earthdata.nasa.gov/search/keywords/data_centers?pretty=true";
    private static final Log log = LogFactory.getLog(CMRDatasourcePlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        return this.generateListOfDatasource();
    }

    private void manageLevel(JsonObject level, List<String> result, Gson g) {
        if (level == null || level.get("subfields") == null) {
            return;
        }
        JsonArray subfields = level.get("subfields").getAsJsonArray();
        subfields.forEach(field -> {
            if ("short_name".equals(field.getAsString())) {
                level.get(field.getAsString()).getAsJsonArray().forEach(it -> this.manageShortName(it.getAsJsonObject(), result, g));
            } else {
                level.get(field.getAsString()).getAsJsonArray().forEach(it -> this.manageLevel(it.getAsJsonObject(), result, g));
            }
        });
    }

    private String getElement(JsonObject element, String key) {
        if (element.get(key) != null) {
            return element.get(key).getAsString();
        }
        return null;
    }

    private void manageShortName(JsonObject item, List<String> result, Gson g) {
        if (item != null && item.get("subfields") == null) {
            String value = this.getElement(item, "value");
            String uuid = this.getElement(item, "uuid");
            this.addDatasource(result, g, uuid, uuid, value, null);
            return;
        }
        JsonArray subfields = item.get("subfields").getAsJsonArray();
        subfields.forEach(field -> {
            if ("short_name".equals(field.getAsString())) {
                item.get(field.getAsString()).getAsJsonArray().forEach(it -> this.manageShortName(it.getAsJsonObject(), result, g));
            }
            if ("long_name".equals(field.getAsString())) {
                this.manageLongName(g, result, item);
            }
            if ("url".equals(field.getAsString())) {
                this.manageURL(item, result, g);
            }
        });
    }

    private void manageURL(JsonObject item, List<String> result, Gson g) {
        String id = this.getElement(item, "value");
        JsonObject firstItem = item.get("url").getAsJsonArray().get(0).getAsJsonObject();
        String url = this.getElement(firstItem, "value");
        String uuid = this.getElement(firstItem, "uuid");
        this.addDatasource(result, g, id, uuid, id, url);
    }

    private void addDatasource(List<String> result, Gson g, String id, String uuid, String value, String url) {
        GenericDatasource currentDatasource = new GenericDatasource();
        try {
            currentDatasource.setId(uuid);
            currentDatasource.setName(value);
            currentDatasource.getExtrafields().put("archive_center", StringEscapeUtils.escapeXml11((String)id));
            currentDatasource.setNamespacePrefix(WDSUtils.generateWDSNsPrefix((String)uuid, (String)"cmr_", (int)12));
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                currentDatasource.setUrl(url);
            }
            result.add(g.toJson((Object)currentDatasource));
        }
        catch (Throwable e1) {
            log.error((Object)"Error on creating list of CMR Datasources", e1);
        }
    }

    private void manageLongName(Gson g, List<String> results, JsonObject item) {
        JsonObject currentItem = item.getAsJsonObject();
        String id = currentItem.get("value").getAsString();
        JsonElement jsonInfo = currentItem.get("long_name");
        if (jsonInfo != null) {
            JsonObject infoObject = jsonInfo.isJsonArray() ? jsonInfo.getAsJsonArray().get(0).getAsJsonObject() : jsonInfo.getAsJsonObject();
            String name = infoObject.get("value").getAsString();
            JsonElement urlObject = infoObject.get("url");
            String url = "";
            String uuid = "";
            if (urlObject != null) {
                if (urlObject.isJsonArray()) {
                    url = urlObject.getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                    uuid = urlObject.getAsJsonArray().get(0).getAsJsonObject().get("uuid").getAsString();
                } else {
                    url = urlObject.getAsJsonObject().get("value").getAsString();
                    uuid = urlObject.getAsJsonObject().get("uuid").getAsString();
                }
            }
            this.addDatasource(results, g, id, uuid, name, url);
        }
    }

    public List<String> generateListOfDatasource() throws CollectorServiceException {
        try {
            URL myUrl = new URL(BASE_URL);
            Gson g = new Gson();
            JsonElement element = new JsonParser().parse(IOUtils.toString((InputStream)myUrl.openStream()));
            JsonObject root = element.getAsJsonObject();
            JsonArray level_0 = root.get("level_0").getAsJsonArray();
            ArrayList<String> results = new ArrayList<String>();
            for (JsonElement levelItem : level_0) {
                this.manageLevel(levelItem.getAsJsonObject(), results, new Gson());
            }
            return results;
        }
        catch (Throwable e) {
            throw new CollectorServiceException("Error on iterating CMR data centers", e);
        }
    }
}

